% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adv.R
\docType{data}
\name{adv}
\alias{adv}
\title{ADV (acoustic-doppler velocimeter) dataset}
\source{
This file came from the SLEIWEX-2008 experiment.
}
\usage{
data(adv)
}
\description{
This \code{\link{adv-class}} object is a sampling of measurements made with a
Nortek Vector acoustic Doppler velocimeter deployed as part of the St Lawrence
Internal Wave Experiment (SLEIWEX).  Various identifying features have been
redacted.
}
\examples{
\dontrun{
library(oce)
data(adv)

# Velocity time-series
plot(adv)

# Spectrum of upward component of velocity, with ``turbulent'' reference line
s <- spectrum(adv[["v"]][,3],plot=FALSE)
plot(log10(s$freq), log10(s$spec), type='l')
for (a in seq(-20, 20, by=1))
    abline(a=a, b=-5/3, col='gray', lty='dotted')
}

}
\seealso{
Other datasets provided with \code{oce}: \code{\link{adp}},
  \code{\link{argo}}, \code{\link{cm}},
  \code{\link{coastlineWorld}}, \code{\link{colors}},
  \code{\link{ctdRaw}}, \code{\link{ctd}},
  \code{\link{echosounder}}, \code{\link{landsat}},
  \code{\link{lisst}}, \code{\link{lobo}},
  \code{\link{met}}, \code{\link{rsk}},
  \code{\link{sealevelTuktoyaktuk}},
  \code{\link{sealevel}}, \code{\link{section}},
  \code{\link{topoWorld}}, \code{\link{wind}}

Other things related to \code{adv} data: \code{\link{[[,adv-method}},
  \code{\link{[[<-,adv-method}}, \code{\link{adv-class}},
  \code{\link{beamName}}, \code{\link{beamToXyz}},
  \code{\link{enuToOtherAdv}}, \code{\link{enuToOther}},
  \code{\link{plot,adv-method}},
  \code{\link{read.adv.nortek}},
  \code{\link{read.adv.sontek.adr}},
  \code{\link{read.adv.sontek.serial}},
  \code{\link{read.adv.sontek.text}},
  \code{\link{read.adv}}, \code{\link{subset,adv-method}},
  \code{\link{summary,adv-method}}, \code{\link{toEnuAdv}},
  \code{\link{toEnu}}, \code{\link{velocityStatistics}},
  \code{\link{xyzToEnuAdv}}, \code{\link{xyzToEnu}}
}
