% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argo.R
\docType{methods}
\name{summary,argo-method}
\alias{summary,argo-method}
\title{Summarize an Argo Object}
\usage{
\S4method{summary}{argo}(object, ...)
}
\arguments{
\item{...}{Further arguments passed to or from other methods.}

\item{object}{an}{object of class \code{"argo"}, usually, a result of a
call to \code{\link{read.argo}}.}
}
\value{
A matrix containing statistics of the elements of the \code{data} slot.
}
\description{
Summarizes some of the data in an \code{argo} object.
}
\details{
Pertinent summary information is presented.
}
\examples{
library(oce)
data(argo)
summary(argo)

}
\seealso{
Other things related to \code{argo} data: \code{\link{[[,argo-method}},
  \code{\link{[[<-,argo-method}}, \code{\link{argo-class}},
  \code{\link{argoGrid}}, \code{\link{argoNames2oceNames}},
  \code{\link{argo}}, \code{\link{as.argo}},
  \code{\link{handleFlags,argo-method}},
  \code{\link{plot,argo-method}}, \code{\link{read.argo}},
  \code{\link{subset,argo-method}}
}
\author{
Dan Kelley
}
