% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argo.R
\name{argoNames2oceNames}
\alias{argoNames2oceNames}
\title{Convert Argo Data Name to Oce Name}
\usage{
argoNames2oceNames(names, ignore.case = TRUE)
}
\arguments{
\item{names}{vector of character strings containing names in the Argo convention.}

\item{ignore.case}{a logical value passed to \code{\link{gsub}}, indicating whether to
ignore the case of input strings. The default is set to \code{TRUE} because some data
files use lower-case names, despite the fact that the Argo documentation specifies
upper-case.}
}
\value{
A character vector of the same length as \code{names}, but with
replacements having been made for all known quantities.
}
\description{
This function is used internally by \code{\link{read.argo}} to convert Argo-convention
data names to oce-convention names. Users should not call this directly, since
its return value may be changed at any moment (e.g. to include units as well
as names).
}
\details{
The inference of names was done
by inspection of some data files, using [1] as a reference. It should be noted,
however, that the data files examined contain some names that are not
undocumented in [1], and others that are listed only in its changelog,
with no actual definitions being given. For example, the files had six distinct
variable names that seem to relate to phase in the oxygen sensor, but
these are not translated by the present function because these
variable names are not defined in [1], or not defined uniquely
in [2].

The names are converted with
\code{\link{gsub}}, using the \code{ignore.case} argument of the present
function.
The procedure
is to first handle the items listed in the following table, with string
searches anchored to the start of the string. After that,
the qualifiers
\code{_ADJUSTED}, \code{_ERROR} and \code{_QC},
are translated to \code{Adjusted}, \code{Error}, and \code{QC}, respectively.
\tabular{ll}{
\strong{Argo name} \tab \strong{oce name}\cr
\code{BBP} \tab \code{bbp}\cr
\code{BETA_BACKSCATTERING} \tab \code{betaBackscattering}\cr
\code{BPHASE_OXY} \tab \code{bphaseOxygen}\cr
\code{CDOM} \tab \code{CDOM}\cr
\code{CNDC} \tab \code{conductivity}\cr
\code{CHLA} \tab \code{chlorophyllA}\cr
\code{CP} \tab \code{beamAttenuation}\cr
\code{CYCLE_NUMBER} \tab \code{cycleNumber}\cr
\code{DATA_CENTRE} \tab \code{dataCentre}\cr
\code{DATA_MODE} \tab \code{dataMode}\cr
\code{DATA_STATE_INDICATOR} \tab \code{dataStateIndicator}\cr
\code{DC_REFERENCE} \tab \code{DCReference}\cr
\code{DIRECTION} \tab \code{direction}\cr
\code{DOWN_IRRADIANCE} \tab \code{downwellingIrradiance}\cr
\code{DOWNWELLING_PAR} \tab \code{downwellingPAR}\cr
\code{FIRMWARE_VERSION} \tab \code{firmwareVersion}\cr
\code{FIT_ERROR_NITRATE} \tab \code{fitErrorNitrate}\cr
\code{FLUORESCENCE_CDOM} \tab \code{fluorescenceCDOM}\cr
\code{FLUORESCENCE_CHLA} \tab \code{fluorescenceChlorophyllA}\cr
\code{INST_REFERENCE} \tab \code{instReference}\cr
\code{JULD} \tab \code{juld} (and used to compute \code{time})\cr
\code{JULD_QC_LOCATION} \tab \code{juldQCLocation}\cr
\code{LATITUDE} \tab \code{latitude}\cr
\code{LONGITUDE} \tab \code{longitude}\cr
\code{MOLAR_DOXY} \tab \code{oxygenUncompensated}\cr
\code{PH_IN_SITU_FREE} \tab \code{pHFree}\cr
\code{PH_IN_SITU_TOTAL} \tab \code{pH}\cr
\code{PI_NAME} \tab \code{PIName}\cr
\code{PLATFORM_NUMBER} \tab \code{id}\cr
\code{POSITION_ACCURACY} \tab \code{positionAccuracy}\cr
\code{POSITIONING_SYSTEM} \tab \code{positioningSystem}\cr
\code{PROFILE} \tab \code{profile}\cr
\code{PROJECT_NAME} \tab \code{projectName}\cr
\code{RAW_DOWNWELLING_IRRADIANCE} \tab \code{rawDownwellingIrradiance}\cr
\code{RAW_DOWNWELLING_PAR} \tab \code{rawDownwellingPAR}\cr
\code{RAW_UPWELLING_RADIANCE} \tab \code{rawUpwellingRadiance}\cr
\code{STATION_PARAMETERS} \tab \code{stationParameters}\cr
\code{TEMP} \tab \code{temperature}\cr
\code{TEMP_CPU_CHLA} \tab \code{temperatureCPUChlorophyllA}\cr
\code{TEMP_DOXY} \tab \code{temperatureOxygen}\cr
\code{TEMP_NITRATE} \tab \code{temperatureNitrate}\cr
\code{TEMP_PH} \tab \code{temperaturePH}\cr
\code{TEMP_SPECTROPHOTOMETER_NITRATE} \tab \code{temperatureSpectrophotometerNitrate}\cr
\code{TILT} \tab \code{tilt}\cr
\code{TURBIDITY} \tab \code{turbidity}\cr
\code{UP_RADIANCE} \tab \code{upwellingRadiance}\cr
\code{UV_INTENSITY} \tab \code{UVIntensity}\cr
\code{UV_INTENSITY_DARK_NITRATE} \tab \code{UVIntensityDarkNitrate}\cr
\code{UV_INTENSITY_NITRATE} \tab \code{UVIntensityNitrate}\cr
\code{VRS_PH} \tab \code{VRSpH}\cr
\code{WMO_INST_TYPE} \tab \code{WMOInstType}\cr
}
}
\references{
1. Argo User's Manual Version 3.2, Dec 29th, 2015, available at
\url{https://archimer.ifremer.fr/doc/00187/29825/40575.pdf}
(but note that this is a draft; newer versions may have
replaced this by now).

2. Argo list of parameters in an excel spreadsheet, available at
\code{https://www.argodatamgt.org/content/download/27444/187206/file/argo-parameters-list-core-and-b.xlsx}
(but note that the certificate at this website was noticed to be invalid on December 17, 2016,
so exercise caution in downloading the file).
}
\seealso{
Other things related to \code{argo} data: \code{\link{[[,argo-method}},
  \code{\link{[[<-,argo-method}}, \code{\link{argo-class}},
  \code{\link{argoGrid}}, \code{\link{argo}},
  \code{\link{as.argo}},
  \code{\link{handleFlags,argo-method}},
  \code{\link{plot,argo-method}}, \code{\link{read.argo}},
  \code{\link{subset,argo-method}},
  \code{\link{summary,argo-method}}
}
\concept{things related to \code{argo} data}
