% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oce.R
\name{oceColorsVelocity}
\alias{oceColorsVelocity}
\alias{oce.colorsVelocity}
\title{Create colors suitable for velocity fields}
\usage{
oceColorsVelocity(n)
}
\arguments{
\item{n}{number of colors to create.}
}
\value{
A vector of color specificications.
}
\description{
Create a set of colors for displaying velocity values,
based on the scheme devised by Kristen M. Thyng
in her \code{cmcolor} Python package, which is available at
\url{https://github.com/kthyng/cmocean}. The
color specifications were downloaded for use here
on 2015-09-29. To avoid changes in \code{oce} scripts,
more recent changes to \code{cmcolor} have not been
tracked; \code{\link{oceColorsClosure}}
has an example of how to incorporate such changes.
}
\examples{
library(oce)
imagep(volcano, col=oceColorsVelocity(128),
       zlab="oceColorsVelocity")

}
\seealso{
Other things related to colors: \code{\link{colormap}},
  \code{\link{oceColors9B}}, \code{\link{oceColorsCDOM}},
  \code{\link{oceColorsChlorophyll}},
  \code{\link{oceColorsClosure}},
  \code{\link{oceColorsDensity}},
  \code{\link{oceColorsFreesurface}},
  \code{\link{oceColorsGebco}}, \code{\link{oceColorsJet}},
  \code{\link{oceColorsOxygen}},
  \code{\link{oceColorsPAR}},
  \code{\link{oceColorsPalette}},
  \code{\link{oceColorsPhase}},
  \code{\link{oceColorsSalinity}},
  \code{\link{oceColorsTemperature}},
  \code{\link{oceColorsTurbidity}},
  \code{\link{oceColorsTwo}},
  \code{\link{oceColorsViridis}},
  \code{\link{oceColorsVorticity}}, \code{\link{ocecolors}}
}
\author{
Krysten M. Thyng (Python version), Dan Kelley (R transliteration)
}
\concept{things related to colors}
