% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moon.R
\name{siderealTime}
\alias{siderealTime}
\title{Convert a POSIXt time to a sidereal time}
\usage{
siderealTime(t)
}
\arguments{
\item{t}{a time, in POSIXt format, e.g. as created by
\code{\link{as.POSIXct}}, \code{\link{as.POSIXlt}}, or
\code{\link{numberAsPOSIXct}}.  If this is provided, the other arguments are
ignored.}
}
\value{
A sidereal time, in hours in the range from 0 to 24.
}
\description{
Convert a POSIXt time to a sidereal time, using
the method in Chapter 7 of Meeus (1982).  The small correction
that he discusses after his equation 7.1 is not applied here.
}
\examples{

t <- ISOdatetime(1978, 11, 13, 0, 0, 0, tz="UTC")
print(siderealTime(t))

}
\references{
Meeus, Jean, 1982.  Astronomical formulae for Calculators.
Willmann-Bell. Richmond VA, USA. 201 pages
}
\seealso{
Other things related to astronomy: \code{\link{eclipticalToEquatorial}},
  \code{\link{equatorialToLocalHorizontal}},
  \code{\link{julianCenturyAnomaly}},
  \code{\link{julianDay}}, \code{\link{moonAngle}},
  \code{\link{sunAngle}}
}
\author{
Dan Kelley
}
\concept{things related to astronomy}
