% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topo.R
\docType{methods}
\name{[[,topo-method}
\alias{[[,topo-method}
\title{Extract Something From a Topo Object}
\usage{
\S4method{[[}{topo}(x, i, j, ...)
}
\arguments{
\item{x}{A topo object, i.e. one inheriting from \code{\link{topo-class}}.}

\item{i}{Character string indicating the name of item to extract.}

\item{j}{Optional additional information on the \code{i} item.}

\item{...}{Optional additional information (ignored).}
}
\description{
The \code{[[} method works for all \code{oce} objects, i.e.
objects inheriting from \code{\link{oce-class}}.  The purpose
is to insulate users from the internal details of \code{oce}
objects, by looking for items within the various storage
slots of the object. Items that are not actually stored in
the object can also be extracted, including derived data such
as potential temperature, the units of measurement for
the data, data-quality flags, etc.
}
\details{
A two-step process is used to try to find the
requested information. First, a class-specific function
tries to find it, but
if that fails, then a general function is used
(see next section).
}
\section{Details of the specialized topo method}{

There are no special features for \code{\link{topo-class}} data;
the general method is used directly.
}

\section{Details of the general method}{


If the specialized method produces no matches, the following generalized
method is applied. As with the specialized method, the procedure hinges
first on the values of \code{i} and, optionally, \code{j}. The work
proceeds in steps, by testing a sequence of possible conditions
in sequence.

\enumerate{

\item A check is made as to whether \code{i} names one of the standard
\code{oce} slots. If so, \code{[[} returns the slot contents of that slot.
Thus, \code{x[["metadata"]]} will retrieve the \code{metadata} slot,
while \code{x[["data"]]} and \code{x[["processingLog"]]} return
those slots.

\item If \code{i} is a string ending in the
\code{"Unit"}, then the characters preceding that string
are taken to be the name of an item in the data object, and a list
containing the unit is returned. This list consists of an item
named \code{unit}, which is an \code{\link{expression}}, and
an item named \code{scale}, which is a string describing the
measurement scale.  If the string ends in \code{" unit"}, e.g.
\code{x[["temperature unit"]]} (note the space),
then just the expression is returned, and if it ends in
\code{" scale"}, then just the scale is returned.

\item If \code{i} is a string ending in \code{"Flag"}, then the corresponding
data-quality flag is returned (or \code{NULL} if there is no such flag).
For example, \code{x[["salinityFlag"]]} returns a vector of salinity
flags if \code{x} is a ctd object.

\item If \code{i} is \code{"sigmaTheta"}, then the value of
\code{\link{swSigmaTheta}(x)} is returned. Similarly,
\code{"sigma0"} returns \code{\link{swSigma0}(x)} and
\code{"spice"} returns \code{\link{swSpice}(x)}. Note that
these relate to seawater properties and only make sense for
certain object types.

\item After these possibilities are eliminated,
the action depends on whether \code{j} has been provided.
If \code{j} is not provided, or is the string \code{""},
then \code{i} is sought
in the \code{metadata} slot, and then in the \code{data} slot,
returning whichever is found first.  In other words, if \code{j}
is not provided, the \code{metadata} slot takes preference over
the \code{data} slot. However, if \code{j} is provided, then
it must be either the string \code{"metadata"} or \code{"data"},
and it directs where to look.
}

If none of the above-listed conditions holds, then \code{NULL} is returned,
without the issuance of a warning or error message. (This silent operation
is employed so that \code{[[} will behave like the normal R version.)
}

\examples{
data(topoWorld)
dim(topoWorld[['z']])

}
\seealso{
Other functions that extract parts of oce objects: \code{\link{[[,adp-method}},
  \code{\link{[[,adv-method}},
  \code{\link{[[,amsr-method}},
  \code{\link{[[,argo-method}},
  \code{\link{[[,bremen-method}},
  \code{\link{[[,cm-method}},
  \code{\link{[[,coastline-method}},
  \code{\link{[[,ctd-method}},
  \code{\link{[[,echosounder-method}},
  \code{\link{[[,g1sst-method}},
  \code{\link{[[,gps-method}},
  \code{\link{[[,ladp-method}},
  \code{\link{[[,landsat-method}},
  \code{\link{[[,lisst-method}},
  \code{\link{[[,lobo-method}},
  \code{\link{[[,met-method}}, \code{\link{[[,oce-method}},
  \code{\link{[[,odf-method}}, \code{\link{[[,rsk-method}},
  \code{\link{[[,sealevel-method}},
  \code{\link{[[,section-method}},
  \code{\link{[[,tidem-method}},
  \code{\link{[[,windrose-method}},
  \code{\link{[[<-,adv-method}}

Other things related to topo data: \code{\link{[[<-,topo-method}},
  \code{\link{as.topo}}, \code{\link{download.topo}},
  \code{\link{plot,topo-method}}, \code{\link{read.topo}},
  \code{\link{subset,topo-method}},
  \code{\link{summary,topo-method}},
  \code{\link{topo-class}}, \code{\link{topoInterpolate}},
  \code{\link{topoWorld}}
}
\concept{functions that extract parts of oce objects}
\concept{things related to topo data}
