% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coastline.R
\name{coastlineCut}
\alias{coastlineCut}
\title{Cut a Coastline Object at Specified Longitude}
\usage{
coastlineCut(coastline, lon_0 = 0)
}
\arguments{
\item{coastline}{a \linkS4class{coastline} object.}

\item{lon_0}{longitude as would be given in a \verb{+lon_0=} item in a
call to the \code{\link[rgdal:project]{rgdal::project()}} function in the \CRANpkg{rgdal} package.}
}
\value{
a new coastline object
}
\description{
This can be helpful in preventing \code{\link[=mapPlot]{mapPlot()}} from producing ugly
horizontal lines in world maps. These lines occur when a coastline segment
is intersected by longitude lon_0+180.  Since the coastline files in the oce
and ocedata packages are already "cut" at longitudes of -180 and 180, the present
function is not needed for default maps, which have \code{+lon_0=0}. However,
may help with other values of \code{lon_0}.
}
\section{Caution}{

This function is provisional. Its behaviour, name and very existence
may change.  Part of the development plan is to see if there is common
ground between this and the \code{clipPolys} function in the
\CRANpkg{PBSmapping} package.
}

\examples{
\donttest{
library(oce)
data(coastlineWorld)
mapPlot(coastlineCut(coastlineWorld, lon_0=100),
        proj="+proj=moll +lon_0=100", col='gray')
}

}
\seealso{
Other things related to coastline data: 
\code{\link{[[,coastline-method}},
\code{\link{[[<-,coastline-method}},
\code{\link{as.coastline}()},
\code{\link{coastline-class}},
\code{\link{coastlineBest}()},
\code{\link{coastlineWorld}},
\code{\link{download.coastline}()},
\code{\link{plot,coastline-method}},
\code{\link{read.coastline.openstreetmap}()},
\code{\link{read.coastline.shapefile}()},
\code{\link{subset,coastline-method}},
\code{\link{summary,coastline-method}}
}
\author{
Dan Kelley
}
\concept{things related to coastline data}
