% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{integrateTrapezoid}
\alias{integrateTrapezoid}
\title{Trapezoidal Integration}
\usage{
integrateTrapezoid(x, y, type = c("A", "dA", "cA"), xmin, xmax)
}
\arguments{
\item{x, y}{vectors of x and y values. In the normal case, these
vectors are both supplied, and of equal length. There are also two
special cases. First, if \code{y} is missing, then
\code{x} is taken to be \code{y}, and a new \code{x} is constructed
as \code{\link{seq_along}}\verb{(y)1. Second, if }length(x)\verb{is 1 and}length(y)\verb{exceeds 1, then}x\verb{is replaced by}x*\code{[}seq_along\verb{]}(y)`.}

\item{type}{Flag indicating the desired return value (see \dQuote{Value}).}

\item{xmin, xmax}{Optional numbers indicating the range of the integration.
These values may be used to restrict the range of integration, or to
extend it; in either case, \code{\link[=approx]{approx()}} with \code{rule=2}
is used to create new x and y vectors.}
}
\value{
If \code{type="A"} (the default), a single value is returned,
containing the estimate of the integral of \code{y=y(x)}.  If
\code{type="dA"}, a numeric vector of the same length as \code{x}, of which
the first element is zero, the second element is the integral between
\code{x[1]} and \code{x[2]}, etc.  If \code{type="cA"}, the result is the
cumulative sum (as in \code{\link[=cumsum]{cumsum()}}) of the values that would be
returned for \code{type="dA"}.  See \dQuote{Examples}.
}
\description{
Estimate the integral of one-dimensional function using the trapezoidal
rule.
}
\section{Bugs}{
 There is no handling of \code{NA} values.
}

\examples{
x <- seq(0, 1, length.out=10) # try larger length.out to see if area approaches 2
y <- 2*x + 3*x^2
A <- integrateTrapezoid(x, y)
dA <- integrateTrapezoid(x, y, "dA")
cA <- integrateTrapezoid(x, y, "cA")
print(A)
print(sum(dA))
print(tail(cA, 1))
print(integrateTrapezoid(diff(x[1:2]), y))
print(integrateTrapezoid(y))
}
\author{
Dan Kelley
}
