% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xbt.R
\name{read.xbt.noaa1}
\alias{read.xbt.noaa1}
\title{Read a NOAA format for AXBTs}
\usage{
read.xbt.noaa1(
  file,
  debug = getOption("oceDebug"),
  missingValue = -9.99,
  processingLog
)
}
\arguments{
\item{file}{character value naming a file, or a file connection, containing the data.}

\item{debug}{a flag that turns on debugging.  The value indicates the depth
within the call stack to which debugging applies.}

\item{missingValue}{numerical value that is to be interpreted as \code{NA}}

\item{processingLog}{if provided, the action item to be stored in the log.  This
parameter is typically only provided for internal calls; the default that it
provides is better for normal calls by a user.}
}
\value{
An \linkS4class{xbt} object.
}
\description{
This file format, described at https://www.aoml.noaa.gov/phod/dhos/axbt.php, contains a header
line, followed by data lines.  For example, a particular file at this site has first
three lines as follows.\preformatted{181.589 20100709 140820  -85.336  25.290 N42RF GL10 14    2010-190-15:49:18
  -0.0 27.52 -9.99
  -1.5 27.52 -9.99
}

where the items on the header line are (1) a year-day (ignored here), (2)
YYYYMMDD, (3) HHMMSS, (4) longitude, (5) latitude, (6) aircraft wing
number, (7) project name, (8) AXBT channel and (9) AXBT ID.  The other lines hold vertical
coordinate in metres, temperature and temperature error; -9.99 is a missing-value
code.  (This formatting information is extracted from a file named \code{readme.axbt} that
is provided with the data.)
}
\seealso{
Other things related to xbt data: 
\code{\link{[[,xbt-method}},
\code{\link{[[<-,xbt-method}},
\code{\link{as.xbt}()},
\code{\link{plot,xbt-method}},
\code{\link{read.xbt}()},
\code{\link{subset,xbt-method}},
\code{\link{summary,xbt-method}},
\code{\link{xbt-class}},
\code{\link{xbt.edf}},
\code{\link{xbt}}
}
\author{
Dan Kelley
}
\concept{things related to xbt data}
