% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/met.R
\name{subset,met-method}
\alias{subset,met-method}
\title{Subset a met Object}
\usage{
\S4method{subset}{met}(x, subset, ...)
}
\arguments{
\item{x}{a \linkS4class{met} object.}

\item{subset}{An expression indicating how to subset \code{x}.}

\item{\dots}{ignored.}
}
\value{
A \linkS4class{met} object.
}
\description{
This function is somewhat analogous to \code{\link[=subset.data.frame]{subset.data.frame()}}.
}
\examples{
library(oce)
data(met)
# Few days surrounding Hurricane Juan
plot(subset(met, time > as.POSIXct("2003-09-27", tz="UTC")))

}
\seealso{
Other things related to met data: 
\code{\link{[[,met-method}},
\code{\link{[[<-,met-method}},
\code{\link{as.met}()},
\code{\link{download.met}()},
\code{\link{met-class}},
\code{\link{met}},
\code{\link{plot,met-method}},
\code{\link{read.met}()},
\code{\link{summary,met-method}},
\code{\link{test_met_csv1.csv}},
\code{\link{test_met_csv2.csv}},
\code{\link{test_met_xml2.xml}}

Other functions that subset oce objects: 
\code{\link{subset,adp-method}},
\code{\link{subset,adv-method}},
\code{\link{subset,amsr-method}},
\code{\link{subset,argo-method}},
\code{\link{subset,cm-method}},
\code{\link{subset,coastline-method}},
\code{\link{subset,ctd-method}},
\code{\link{subset,echosounder-method}},
\code{\link{subset,lobo-method}},
\code{\link{subset,oce-method}},
\code{\link{subset,odf-method}},
\code{\link{subset,rsk-method}},
\code{\link{subset,sealevel-method}},
\code{\link{subset,section-method}},
\code{\link{subset,topo-method}},
\code{\link{subset,xbt-method}}
}
\author{
Dan Kelley
}
\concept{functions that subset oce objects}
\concept{things related to met data}
