% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tides.R
\name{tidemConstituentNameFix}
\alias{tidemConstituentNameFix}
\title{Change tidal constituent name from T-TIDE to Foreman convention}
\usage{
tidemConstituentNameFix(names, debug = 1)
}
\arguments{
\item{names}{a vector of character values, holding constituent names}

\item{debug}{an integer controlling warnings. If this is zero, then no warnings
are issued during processing; otherwise, as is the default, warnings are
issued for each conversion that is required.}
}
\value{
A vector of character values of tidal constituent names, in the Foreman naming convention.
}
\description{
This is used by \code{\link[=tidem]{tidem()}} to permit users to specify constituent names in either
the T-TIDE convention (see Pawlowicz et al. 2002) or Foreman convention
(see Foreman (1978). There are only two such instances:
\code{"MS"}, which gets translated to \code{"M8"}, and \code{"UPSI"},
which gets translated to \code{"UPS1"}.
}
\references{
Foreman, M. G. G., 1978. Manual for Tidal Currents Analysis and Prediction.
Pacific Marine Science Report. British Columbia, Canada: Institute of Ocean
Sciences, Patricia Bay.

Pawlowicz, Rich, Bob Beardsley, and Steve Lentz, 2002.  Classical tidal
harmonic analysis including error estimates in MATLAB using \code{T_TIDE}.
Computers and Geosciences, 28, 929-937.
}
