% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echosounder.R
\name{as.echosounder}
\alias{as.echosounder}
\title{Coerce Data into an Echosounder Object}
\usage{
as.echosounder(
  time,
  depth,
  a,
  src = "",
  sourceLevel = 220,
  receiverSensitivity = -55.4,
  transmitPower = 0,
  pulseDuration = 400,
  beamwidthX = 6.5,
  beamwidthY = 6.5,
  frequency = 41800,
  correction = 0
)
}
\arguments{
\item{time}{times of pings.}

\item{depth}{depths of samples within pings.}

\item{a}{matrix of echo amplitudes, as would be stored with
\code{\link[=read.echosounder]{read.echosounder()}}.}

\item{src}{optional string indicating data source.}

\item{sourceLevel}{source level, in dB (uPa at 1m), denoted \code{sl} in
reference 1 p15, where it is in units 0.1dB (uPa at 1m).}

\item{receiverSensitivity}{receiver sensitivity of the main element, in
dB(counts/uPa), denoted \code{rs} in reference 1 p15, where it is in units of
0.1dB(counts/uPa)}

\item{transmitPower}{transmit power reduction factor, in dB, denoted
\code{tpow} in reference 1 p10, where it is in units 0.1 dB.}

\item{pulseDuration}{duration of transmitted pulse in us}

\item{beamwidthX}{x-axis -3dB one-way beamwidth in deg, denoted \code{bwx}
in reference 1 p16, where the unit is 0.2 deg}

\item{beamwidthY}{y-axis -3dB one-way beamwidth in deg, denoted \code{bwx}
in reference 1 p16, where the unit is 0.2 deg}

\item{frequency}{transducer frequency in Hz, denoted \code{fq} in reference 1 p16}

\item{correction}{user-defined calibration correction in dB, denoted
\code{corr} in reference 1 p14, where the unit is 0.01dB.}
}
\value{
An \linkS4class{echosounder} object.
}
\description{
Coerces a dataset into a echosounder dataset.
}
\details{
Creates an echosounder file.  The defaults for e.g.  \code{transmitPower}
are taken from the \code{echosounder} dataset, and they are unlikely to make
sense generally.  The first three parameters must be supplied, and the
dimension of \code{a} must align with the lengths of \code{time} and \code{depths}. The
other parameters have defaults that are unlikely to be correct for
arbitrary application, but they are not essential for basic plots,
etc.

Those who use the \CRANpkg{readHAC} package to read echosounder
data should note that it stores the \code{a} matrix in a flipped and
transposed format. See that package's demo code for a function
named \code{flip()} that transforms the matrix as required by
\code{\link[=as.echosounder]{as.echosounder()}}. Indeed, users working with HAC
data ought to study the whole of the \CRANpkg{readHAC}
documentation, to learn what data are stored, so that
\code{\link[=oceSetMetadata]{oceSetMetadata()}} and \code{\link[=oceSetData]{oceSetData()}} can be used as needed
to flesh out the contents returned by \code{\link[=as.echosounder]{as.echosounder()}}.
}
\seealso{
Other things related to echosounder data: 
\code{\link{[[,echosounder-method}},
\code{\link{[[<-,echosounder-method}},
\code{\link{echosounder-class}},
\code{\link{echosounder}},
\code{\link{findBottom}()},
\code{\link{plot,echosounder-method}},
\code{\link{read.echosounder}()},
\code{\link{subset,echosounder-method}},
\code{\link{summary,echosounder-method}}
}
\author{
Dan Kelley
}
\concept{things related to echosounder data}
