% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oce.R
\name{oceMagic}
\alias{oceMagic}
\title{Find the Type of an Oceanographic Data File}
\usage{
oceMagic(file, encoding = "latin1", debug = getOption("oceDebug"))
}
\arguments{
\item{file}{a connection or a character string giving the name of the file
to be checked.}

\item{encoding}{a character value that indicates the encoding to be used for
this data file, if it is textual.  The default value for most functions is
\code{"latin1"}, which seems to be suitable for files containing text written in
English and French.}

\item{debug}{an integer, set non-zero to turn on debugging.  Higher values
indicate more debugging.}
}
\value{
A character string indicating the file type, or \code{"unknown"}, if
the type cannot be determined. If the result contains \code{"/"} characters,
these separate a list describing the file type, with the first element being
the general type, the second element being the manufacturer, and the third
element being the manufacturer's name for the instrument. For example,
\code{"adp/nortek/aquadopp"} indicates a acoustic-doppler profiler made by
NorTek, of the model type called Aquadopp.
}
\description{
\code{oceMagic} tries to infer the file type, based on the data
within the file, the file name, or a combination of the two.
}
\details{
\code{oceMagic} was previously called \code{oce.magic}, but that
alias was removed in version 0.9.24; see \link{oce-defunct}.
}
\seealso{
This is used mainly by \code{\link[=read.oce]{read.oce()}}.
}
\author{
Dan Kelley
}
