% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coastline.R
\name{subset,coastline-method}
\alias{subset,coastline-method}
\alias{subset.coastline}
\title{Subset a Coastline Object}
\usage{
\S4method{subset}{coastline}(x, subset, ...)
}
\arguments{
\item{x}{a \linkS4class{coastline} object.}

\item{subset}{An expression indicating how to subset \code{x}. See \dQuote{Details}.}

\item{...}{optional additional arguments, the only one of which is considered
is one named \code{debug}, an integer that controls the level of debugging. If
this is not supplied, \code{debug} is assumed to be 0, meaning no debugging. If
it is 1, the steps of determining the bounding box are shown. If it is 2 or larger,
then additional processing steps are shown, including the extraction of every
polygon involved in the final result.}
}
\value{
A \code{coastline} object.
}
\description{
Subsets a coastline object according to limiting values for longitude
and latitude.
}
\details{
As illustrated in the \dQuote{Examples}, \code{subset} must be an
expression that indicates limits on \code{latitude} and
\code{longitude}. The individual elements are provided in R notation,
not mathematical notation (i.e. \verb{30<latitude<60} would not work).
Ampersands must be used to combine the limits.  The simplest way
to understand this is to copy the example directly, and then modify
the stated limits. Note that \code{>} comparison is not permitted,
and that \code{<} is converted to \code{<=} in the calculation.
Similarly, \code{&&} is converted to \code{&}. Spaces in the
expression are ignored. For convenience, \code{longitude} and
and \code{latitude} may be abbreviated as \code{lon} and \code{lat},
as in the \dQuote{Examples}.
}
\examples{
library(oce)
data(coastlineWorld)
# Subset to a box centred on Nova Scotia, Canada
if (requireNamespace("sf")) {
    cl <- subset(coastlineWorld, -80<lon & lon<-50 & 30<lat & lat<60)
    # The plot demonstrates that the trimming is as requested.
    plot(cl, clon=-65, clat=45, span=6000)
    rect(-80, 30, -50, 60, bg="transparent", border="red")
}
}
\seealso{
Other things related to coastline data: 
\code{\link{[[,coastline-method}},
\code{\link{[[<-,coastline-method}},
\code{\link{as.coastline}()},
\code{\link{coastline-class}},
\code{\link{coastlineBest}()},
\code{\link{coastlineCut}()},
\code{\link{coastlineWorld}},
\code{\link{download.coastline}()},
\code{\link{plot,coastline-method}},
\code{\link{read.coastline.openstreetmap}()},
\code{\link{read.coastline.shapefile}()},
\code{\link{summary,coastline-method}}

Other functions that subset oce objects: 
\code{\link{subset,adp-method}},
\code{\link{subset,adv-method}},
\code{\link{subset,amsr-method}},
\code{\link{subset,argo-method}},
\code{\link{subset,cm-method}},
\code{\link{subset,ctd-method}},
\code{\link{subset,echosounder-method}},
\code{\link{subset,lobo-method}},
\code{\link{subset,met-method}},
\code{\link{subset,oce-method}},
\code{\link{subset,odf-method}},
\code{\link{subset,rsk-method}},
\code{\link{subset,sealevel-method}},
\code{\link{subset,section-method}},
\code{\link{subset,topo-method}},
\code{\link{subset,xbt-method}}
}
\author{
Dan Kelley
}
\concept{functions that subset oce objects}
\concept{things related to coastline data}
