% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tides.R
\name{summary,tidem-method}
\alias{summary,tidem-method}
\title{Summarize a Tidem Object}
\usage{
\S4method{summary}{tidem}(object, p = 1, constituent, ...)
}
\arguments{
\item{object}{an object of class \link{tidem}, as created by
\code{\link[=as.tidem]{as.tidem()}} or \code{\link[=tidem]{tidem()}}.}

\item{p}{optional value of the maximum p value for the display of an
individual coefficient.  If not given, all coefficients are shown.}

\item{constituent}{optional character vector holding the names
of constituents on which to focus.}

\item{\dots}{further arguments passed to or from other methods.}
}
\value{
\code{NULL}
}
\description{
By default, all fitted constituents are plotted, but it is quite useful to
set e.g. p=0.05 To see just those constituents that are significant at the 5
percent level.
Note that the p values are estimated as the average of the p values for the
sine and cosine components at a given frequency.
}
\examples{
\dontrun{
library(oce)
data(sealevel)
tide <- tidem(sealevel)
summary(tide)
}

}
\seealso{
Other things related to tides: 
\code{\link{[[,tidem-method}},
\code{\link{[[<-,tidem-method}},
\code{\link{as.tidem}()},
\code{\link{plot,tidem-method}},
\code{\link{predict.tidem}()},
\code{\link{tidalCurrent}},
\code{\link{tidedata}},
\code{\link{tidem-class}},
\code{\link{tidemAstron}()},
\code{\link{tidemVuf}()},
\code{\link{tidem}},
\code{\link{webtide}()}
}
\author{
Dan Kelley
}
\concept{things related to tides}
