% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sw.R
\name{swTSrho}
\alias{swTSrho}
\title{Seawater temperature from salinity and density}
\usage{
swTSrho(
  salinity,
  density,
  pressure = NULL,
  eos = getOption("oceEOS", default = "gsw")
)
}
\arguments{
\item{salinity}{\emph{in-situ} salinity (PSU)}

\item{density}{\emph{in-situ} density or sigma value (kg/m\eqn{^3}{^3})}

\item{pressure}{\emph{in-situ} pressure (dbar)}

\item{eos}{equation of state to be used, either \code{"unesco"} or
\code{"gsw"} (ignored at present).}
}
\value{
\emph{In-situ} temperature in \eqn{^\circ}{deg}C on the ITS-90
scale.
}
\description{
Compute \emph{in-situ} temperature, given salinity, density, and pressure.
}
\details{
Finds the temperature that yields the given density, with the given salinity
and pressure.  The method is a bisection search with temperature tolerance
0.001 \eqn{^\circ}{deg}C.
}
\examples{
swTSrho(35, 23, 0, eos="unesco") # 26.11301

}
\references{
Fofonoff, P. and R. C. Millard Jr, 1983. Algorithms for
computation of fundamental properties of seawater. \emph{Unesco Technical
Papers in Marine Science}, \emph{44}, 53 pp

Gill, A.E., 1982. \emph{Atmosphere-ocean Dynamics}, Academic Press, New
York, 662 pp.
}
\seealso{
\code{\link[=swSTrho]{swSTrho()}}

Other functions that calculate seawater properties: 
\code{\link{T68fromT90}()},
\code{\link{T90fromT48}()},
\code{\link{T90fromT68}()},
\code{\link{computableWaterProperties}()},
\code{\link{locationForGsw}()},
\code{\link{swAbsoluteSalinity}()},
\code{\link{swAlphaOverBeta}()},
\code{\link{swAlpha}()},
\code{\link{swBeta}()},
\code{\link{swCSTp}()},
\code{\link{swConservativeTemperature}()},
\code{\link{swDepth}()},
\code{\link{swDynamicHeight}()},
\code{\link{swLapseRate}()},
\code{\link{swN2}()},
\code{\link{swPressure}()},
\code{\link{swRho}()},
\code{\link{swRrho}()},
\code{\link{swSCTp}()},
\code{\link{swSR}()},
\code{\link{swSTrho}()},
\code{\link{swSigma0}()},
\code{\link{swSigma1}()},
\code{\link{swSigma2}()},
\code{\link{swSigma3}()},
\code{\link{swSigma4}()},
\code{\link{swSigmaTheta}()},
\code{\link{swSigmaT}()},
\code{\link{swSigma}()},
\code{\link{swSoundAbsorption}()},
\code{\link{swSoundSpeed}()},
\code{\link{swSpecificHeat}()},
\code{\link{swSpice}()},
\code{\link{swSstar}()},
\code{\link{swTFreeze}()},
\code{\link{swThermalConductivity}()},
\code{\link{swTheta}()},
\code{\link{swViscosity}()},
\code{\link{swZ}()}
}
\author{
Dan Kelley
}
\concept{functions that calculate seawater properties}
