% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argo.R
\name{argoGrid}
\alias{argoGrid}
\title{Grid Argo Float Data}
\usage{
argoGrid(argo, p, debug = getOption("oceDebug"), ...)
}
\arguments{
\item{argo}{A \code{argo} object to be gridded.}

\item{p}{Optional indication of the pressure levels to which interpolation
should be done.  If this is not supplied, the pressure levels will be
calculated based on the existing values, using medians. If \code{p="levitus"},
then pressures will be set to be those of the Levitus atlas, given by
\code{\link[=standardDepths]{standardDepths()}}, trimmed to the maximum pressure in \code{argo}.
If \code{p} is a single numerical value, it is taken as the number of
subdivisions to use in a call to \code{\link[=seq]{seq()}} that has range from 0 to the
maximum pressure in \code{argo}.  Finally, if a vector numerical values is
provided, then it is used as is.}

\item{debug}{A flag that turns on debugging.  Higher values provide deeper
debugging.}

\item{...}{Optional arguments to \code{\link[=approx]{approx()}}, which is used to do the
gridding.}
}
\value{
x an \linkS4class{argo} object.
}
\description{
Grid an Argo float, by interpolating to fixed pressure levels.
The gridding is done with \code{\link[=approx]{approx()}}.  If there is
sufficient user demand, other methods may be added, by analogy to
\code{\link[=sectionGrid]{sectionGrid()}}.
}
\section{A note about flags}{


Data-quality flags contained within the original object are ignored by this
function, and the returned value contains no such flags.  This is because such
flags represent an assessment of the original data, not of quantities derived
from those data.  This function produces a warning to this effect. The
recommended practice is to use \code{\link[=handleFlags]{handleFlags()}} or some other means to
deal with flags before calling the present function.
}

\examples{
library(oce)
data(argo)
g <- argoGrid(argo, p = seq(0, 100, 1))
par(mfrow = c(2, 1))
t <- g[["time"]]
z <- -g[["pressure"]][, 1]
# Set zlim because of spurious temperatures.
imagep(t, z, t(g[["temperature"]]), ylim = c(-100, 0), zlim = c(0, 20))
imagep(t, z, t(g[["salinity"]]), ylim = c(-100, 0))

}
\seealso{
Other things related to argo data: 
\code{\link{[[,argo-method}},
\code{\link{[[<-,argo-method}},
\code{\link{argo-class}},
\code{\link{argoNames2oceNames}()},
\code{\link{argo}},
\code{\link{as.argo}()},
\code{\link{handleFlags,argo-method}},
\code{\link{plot,argo-method}},
\code{\link{read.argo.copernicus}()},
\code{\link{read.argo}()},
\code{\link{subset,argo-method}},
\code{\link{summary,argo-method}}
}
\author{
Dan Kelley and Clark Richards
}
\concept{things related to argo data}
