% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geod.R
\name{geodGc}
\alias{geodGc}
\title{Great-circle Segments Between Points on Earth}
\usage{
geodGc(longitude, latitude, dmax)
}
\arguments{
\item{longitude}{vector of longitudes, in degrees east}

\item{latitude}{vector of latitudes, in degrees north}

\item{dmax}{maximum angular separation to tolerate between sub-segments, in
degrees.}
}
\value{
Data frame of \code{longitude} and \code{latitude}.
}
\description{
Each pair in the \code{longitude} and \code{latitude} vectors is considered
in turn.  For long vectors, this may be slow.
}
\examples{
\donttest{
library(oce)
data(coastlineWorld)
mapPlot(coastlineWorld,
    type = "l",
    longitudelim = c(-80, 10), latitudelim = c(35, 80),
    projection = "+proj=merc"
)
# Great circle from New York to Paris (Lindberg's flight)
l <- geodGc(c(-73.94, 2.35), c(40.67, 48.86), 1)
mapLines(l$longitude, l$latitude, col = "red", lwd = 2)
}

}
\references{
\enumerate{
\item \verb{http://williams.best.vwh.net/avform.htm#Intermediate}
(link worked for years but failed 2017-01-16).
}
}
\seealso{
Other functions relating to geodesy: 
\code{\link{geodDist}()},
\code{\link{geodXyInverse}()},
\code{\link{geodXy}()}
}
\author{
Dan Kelley, based on code from Clark Richards, in turn based on
formulae provided by Ed Williams (see reference 1)].
}
\concept{functions relating to geodesy}
