% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsk.R
\docType{data}
\name{rsk}
\alias{rsk}
\title{Sample rsk Data}
\description{
A sample \code{rsk} object derived from a Concerto CTD manufactured by RBR Ltd.
}
\details{
The data were obtained September 2015, off the west coast
of Greenland, by Matt Rutherford and Nicole Trenholm of the
Ocean Research Project, in collaboration with RBR and with the
NASA Oceans Melting Greenland project. The \code{rsk} object was
created with \code{\link[=read.rsk]{read.rsk()}} with \code{allTables=FALSE}, after which
some metadata were added and the samples were trimmed to
just the downcast portion.
}
\examples{
library(oce)
data(rsk)
# The object doesn't "know" it is CTD until told so
plot(rsk)
plot(as.ctd(rsk))

}
\references{
\verb{https://rbr-global.com/}
}
\seealso{
Other datasets provided with oce: 
\code{\link{adp}},
\code{\link{adv}},
\code{\link{amsr}},
\code{\link{argo}},
\code{\link{cm}},
\code{\link{coastlineWorld}},
\code{\link{ctdRaw}},
\code{\link{ctd}},
\code{\link{echosounder}},
\code{\link{landsat}},
\code{\link{lisst}},
\code{\link{lobo}},
\code{\link{met}},
\code{\link{ocecolors}},
\code{\link{sealevelTuktoyaktuk}},
\code{\link{sealevel}},
\code{\link{section}},
\code{\link{topoWorld}},
\code{\link{wind}},
\code{\link{xbt}}

Other things related to rsk data: 
\code{\link{[[,rsk-method}},
\code{\link{[[<-,rsk-method}},
\code{\link{as.rsk}()},
\code{\link{ctdFindProfilesRBR}()},
\code{\link{plot,rsk-method}},
\code{\link{read.rsk}()},
\code{\link{rsk-class}},
\code{\link{rskPatm}()},
\code{\link{rskToc}()},
\code{\link{subset,rsk-method}},
\code{\link{summary,rsk-method}}
}
\concept{datasets provided with oce}
\concept{things related to rsk data}
