% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R
\name{setFlags,oce-method}
\alias{setFlags,oce-method}
\title{Set Data-Quality Flags within a oce Object}
\usage{
\S4method{setFlags}{oce}(
  object,
  name = NULL,
  i = NULL,
  value = NULL,
  debug = getOption("oceDebug")
)
}
\arguments{
\item{object}{An oce object.}

\item{name}{Character string indicating the name of the variable to be flagged. If
this variable is not contained in the object's \code{data} slot, an error is reported.}

\item{i}{Indication of where to insert the flags; see \dQuote{Description} for
general rules and \dQuote{Details} for rules for \linkS4class{oce}
objects.}

\item{value}{The value to be inserted in the flag.}

\item{debug}{Integer set to 0 for quiet action or to 1 for some debugging.}
}
\value{
An object with flags set as indicated.
}
\description{
This function changes specified entries in the data-quality
flags of a oce object, which are stored within
a list named \code{flags} that resides in the \code{metadata}
slot. If the object already has a flag set up for \code{name},
then only the specified entries are altered. If not, the flag
entry is first created and its entries set to \code{default},
after which the entries specified by \code{i}
are changed to \code{value}.

The specification is made with \code{i}, the form of which
is determined by the data item in question. Generally,
the rules are as follows:
\enumerate{
\item If the data item is a vector, then \code{i} must be (a)
an integer vector specifying indices to be set to \code{value},
(b) a logical vector of length matching the data item, with
\code{TRUE} meaning to set the flag to \code{value}, or (c)
a function that takes an \code{oce} object as its single
argument, and returns a vector in either of the forms
just described.
\item If the data item is an array, then \code{i} must be
(a) a data frame of integers whose rows specify spots to change
(where the number of columns matches the number of dimensions
of the data item), (b) a logical array that has dimension equal to
that of the data item, or (c) a function that takes an \code{oce}
object as its single input and returns such a data frame or array.
}

See \dQuote{Details} for the particular case of \linkS4class{oce} objects.
}
\details{
This generic function is overridden by specialized functions for some object classes.
}
\seealso{
Other functions relating to data-quality flags: 
\code{\link{defaultFlags}()},
\code{\link{handleFlags,adp-method}},
\code{\link{handleFlags,argo-method}},
\code{\link{handleFlags,ctd-method}},
\code{\link{handleFlags,oce-method}},
\code{\link{handleFlags,section-method}},
\code{\link{handleFlags}()},
\code{\link{initializeFlagScheme,ctd-method}},
\code{\link{initializeFlagScheme,oce-method}},
\code{\link{initializeFlagScheme,section-method}},
\code{\link{initializeFlagSchemeInternal}()},
\code{\link{initializeFlagScheme}()},
\code{\link{initializeFlags,adp-method}},
\code{\link{initializeFlags,oce-method}},
\code{\link{initializeFlagsInternal}()},
\code{\link{initializeFlags}()},
\code{\link{setFlags,adp-method}},
\code{\link{setFlags,ctd-method}},
\code{\link{setFlags}()}
}
\concept{functions relating to data-quality flags}
