% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oceanis-package.R
\name{export_qgis_}
\alias{export_qgis_}
\alias{export_qgis_ronds}
\alias{export_qgis_classes}
\alias{export_qgis_ronds_classes}
\alias{export_qgis_classes_ronds}
\alias{export_qgis_typo}
\alias{export_qgis_oursins}
\alias{export_qgis_joignantes}
\alias{export_qgis_saphirs}
\title{Export a 'leaflet' map to Qgis project}
\usage{
export_qgis_ronds(map, cheminDossier, nomFichier, titre1 = "", titre2
= "", source = "")

export_qgis_classes(map, cheminDossier, nomFichier, titre1 = "", titre2 =
"", source = "")

export_qgis_ronds_classes(map, cheminDossier, nomFichier, titre1 = "",
titre2 = "", source = "")

export_qgis_classes_ronds(map, cheminDossier, nomFichier, titre1 = "",
titre2 = "", source = "")

export_qgis_typo(map, cheminDossier, nomFichier, titre1 = "", titre2 = "",
source = "")

export_qgis_oursins(map, cheminDossier, nomFichier, titre1 = "", titre2 =
"", source = "")

export_qgis_joignantes(map, cheminDossier, nomFichier, titre1 = "", titre2 =
"", source = "")

export_qgis_saphirs(map, cheminDossier, nomFichier, titre1 = "", titre2 =
"", source = "")
}
\arguments{
\item{map}{objet leaflet.}

\item{cheminDossier}{chaine de caracteres (character). Chemin du dossier
d'exportation du projet.}

\item{nomFichier}{chaine de caracteres (character). Nom du projet en sortie
sans l'extension.}

\item{titre1}{chaine de caracteres (character). Titre principal de la carte,
le plus souvent informatif.}

\item{titre2}{chaine de caracteres (character). Titre secondaire de la
carte, le plus souvent descriptif.}

\item{source}{chaine de caracteres (character). Source de la carte.}
}
\value{
Ne retourne aucun objet.

Exporte la carte en projet Qgis a l'emplacement specifie.
}
\description{
Export a 'leaflet' map to Qgis project.
}
\details{
Il faut obligatoirement ajouter la legende a la carte avant d'utiliser la
fonction d'export Qgis.

Le projet .qgs est associe a tous les fonds ShapeFile qui composent la carte
(.shp, .dbf, .prj, .shx).

Attention, l'export du projet Qgis peut durer quelques minutes.
}
\examples{

data("depm")
data("regm")

data("donnees_monoloc")

# Ronds proportionnels
map <- leaflet_ronds(data = donnees_monoloc, fondMaille = depm,
idData = "COD_DEP", varVolume = "POP_2015")
map <- add_legende_ronds(map = map, titre = "POP_2015", lng = 9, lat = 50, zoom = 6)

\donttest{
 ## Not run:
 export_qgis_ronds(map = map, cheminDossier = tempdir(), nomFichier = "projet_qgis",
 source = "Source : INSEE - RP2016")
 ## End(Not run)
}

}
\seealso{
\code{\link{leaflet_ronds}, \link{leaflet_classes},
\link{leaflet_ronds_classes}, \link{leaflet_classes_ronds},}

\code{\link{leaflet_typo}, \link{leaflet_oursins},
\link{leaflet_joignantes}, \link{leaflet_saphirs}}
}
\keyword{documentation}
