\name{glzcs}
\alias{glzcs}
\title{
Support for Groups and Subgroups
in the Generalized Dendrogram
}
\description{
Generates three metrics
of support for the observed clusters
at all hierarchical levels
}
\usage{
glzcs(GRPs=GRPs, M2=M2)
}
\arguments{
  \item{GRPs}{
List object generated by the functions IDscluster & IDscluster2
}
  \item{M2}{
Class list object generated by the functions glzcluster or glzcluster2
}
}

\value{
A table with supporting values and size of every group: integrity, 
contamination, probability and group size.
}
\references{
Koleff, P., Gaston, K.J., Lennon, J. J. 2003. Measuring beta diversity for 
presence-absence data. Journal of Animal Ecology 71:367.
https://doi.org/10.1046/j.1365-2656.2003.00710.x
}
\author{
Roger Guevara (roger.guevara@inecol.mx) & 
Ian MacGregor-Fors (ian.macgregor@helsinki.fi)
}
\examples{
data(dune)
OCT <- glzcluster(dune, n=100)
GRP <- IDscluster(OCT)
SUP <- glzcs(GRP, OCT)
SUP
}

