% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbi-driver.R
\name{odbc}
\alias{odbc}
\alias{dbConnect,OdbcDriver-method}
\alias{dbConnect}
\title{Connect to a database via an ODBC driver}
\usage{
odbc()

\S4method{dbConnect}{OdbcDriver}(
  drv,
  dsn = NULL,
  ...,
  timezone = "UTC",
  timezone_out = "UTC",
  encoding = "",
  bigint = c("integer64", "integer", "numeric", "character"),
  timeout = 10,
  driver = NULL,
  server = NULL,
  database = NULL,
  uid = NULL,
  pwd = NULL,
  dbms.name = NULL,
  attributes = NULL,
  .connection_string = NULL
)
}
\arguments{
\item{drv}{An \code{OdbcDriver}, from \code{odbc()}.}

\item{dsn}{The data source name. For currently available options, see the
\code{name} column of \code{\link[=odbcListDataSources]{odbcListDataSources()}} output.}

\item{...}{Additional ODBC keywords. These will be joined with the other
arguments to form the final connection string.

Note that ODBC parameter names are case-insensitive so that (e.g.) \code{DRV}
and \code{drv} are equivalent. Since this is different to R and a possible
source of confusion, odbc will error if you supply multiple arguments that
have the same name when case is ignored.

Any argument values that contain \verb{[]\{\}(),;?*=!@} will be "quoted" by
wrapping in \code{{}}. You can opt-out of this behaviour by wrapping the
value with \code{I()}.}

\item{timezone}{The server time zone. Useful if the database has an internal
timezone that is \emph{not} 'UTC'. If the database is in your local timezone,
set this argument to \code{\link[=Sys.timezone]{Sys.timezone()}}. See \code{\link[=OlsonNames]{OlsonNames()}} for a complete
list of available time zones on your system.}

\item{timezone_out}{The time zone returned to R. If you want to display
datetime values in the local timezone, set to \code{\link[=Sys.timezone]{Sys.timezone()}}.}

\item{encoding}{The text encoding used on the Database. If the database is
not using UTF-8 you will need to set the encoding to get accurate
re-encoding. See \code{\link[=iconvlist]{iconvlist()}} for a complete list of available encodings
on your system. Note strings are always returned \code{UTF-8} encoded.}

\item{bigint}{The R type that \code{SQL_BIGINT} types should be mapped to.
Default is \link[bit64:bit64-package]{bit64::integer64}, which allows the full range of 64 bit
integers.}

\item{timeout}{Time in seconds to timeout the connection attempt. Setting a
timeout of \code{Inf} indicates no timeout. Defaults to 10 seconds.}

\item{driver}{The ODBC driver name or a path to a driver. For currently
available options, see the \code{name} column of \code{\link[=odbcListDrivers]{odbcListDrivers()}} output.}

\item{server}{The server hostname. Some drivers use \code{Servername} as the name
for this argument. Not required when configured for the supplied \code{dsn}.}

\item{database}{The database on the server. Not required when configured for
the supplied \code{dsn}.}

\item{uid}{The user identifier. Some drivers use \code{username} as the name
for this argument. Not required when configured for the supplied \code{dsn}.}

\item{pwd}{The password. Some drivers use \code{password} as the name
for this argument. Not required when configured for the supplied \code{dsn}.}

\item{dbms.name}{The database management system name. This should normally
be queried automatically by the ODBC driver. This name is used as the class
name for the OdbcConnection object returned from \code{\link[=dbConnect]{dbConnect()}}. However, if
the driver does not return a valid value, it can be set manually with this
parameter.}

\item{attributes}{An S4 object of connection attributes that are passed
prior to the connection being established. See \link{ConnectionAttributes}.}

\item{.connection_string}{A complete connection string, useful if you are
copy pasting it from another source. If this argument is used, any
additional arguments will be appended to this string.}
}
\description{
The \code{dbConnect()} method documented here is invoked when \code{\link[DBI:dbConnect]{DBI::dbConnect()}}
is called with the first argument \code{odbc()}. Connecting to a database via
an ODBC driver is likely the first step in analyzing data using the odbc
package; for an overview of package concepts, see the \emph{Overview} section
below.
}
\section{Connection strings}{


Internally, \code{dbConnect()} creates a connection string using the supplied
arguments. Connection string keywords are driver-dependent; the arguments
documented here are common, but some drivers may not accept them.

Alternatively to configuring DSNs and driver names with the driver manager,
you can pass a complete connection string directly as the
\code{.connection_string} argument.
\href{https://www.connectionstrings.com}{The Connection Strings Reference} is a
useful resource that has example connection strings for a large variety of
databases.
}

\section{Overview}{


The odbc package is one piece of the R interface to databases with support
for ODBC:

\figure{whole-game.png}{options: width=95\%}

The package supports any \strong{Database Management System (DBMS)} with ODBC
support. Support for a given DBMS is provided by an \strong{ODBC driver}, which
defines how to interact with that DBMS using the standardized syntax of ODBC
and SQL. Drivers can be downloaded from the DBMS vendor or, if you're a Posit
customer, using the \href{https://docs.posit.co/pro-drivers/}{professional drivers}.
To manage information about each driver and the data sources they provide
access to, our computers use a \strong{driver manager}. Windows is bundled with
a driver manager, while MacOS and Linux require installation of one; this
package supports the \href{https://www.unixodbc.org/}{unixODBC} driver manager.

In the \strong{R interface}, the \href{https://dbi.r-dbi.org/}{DBI package} provides a
front-end while odbc implements a back-end to communicate with the driver
manager. The odbc package is built on top of the
\href{https://nanodbc.github.io/nanodbc/}{nanodbc} C++ library.

Interfacing with DBMSs using R and odbc involves three high-level steps:
\enumerate{
\item \emph{Configure drivers and data sources}: the functions \code{\link[=odbcListDrivers]{odbcListDrivers()}}
and \code{\link[=odbcListDataSources]{odbcListDataSources()}} help to interface with the driver manager.
\item \emph{Connect to a database}: The \code{\link[=dbConnect]{dbConnect()}} function, called with the
first argument odbc(), connects to a database using the specified ODBC
driver to create a connection object.
\item \emph{Interface with connections}: The resulting connection object can be
passed to various functions to retrieve information on database
structure (\code{\link[=dbListTables]{dbListTables()}}), iteratively develop queries (\code{\link[=dbSendQuery]{dbSendQuery()}},
\code{\link[=dbColumnInfo]{dbColumnInfo()}}), and query data objects (\code{\link[=dbFetch]{dbFetch()}}).
}
}

\section{Learn more}{


To learn more about databases:
\itemize{
\item \href{https://solutions.posit.co/connections/db/}{"Best Practices in Working with Databases"}
documents how to use the odbc package with various popular databases.
\item \href{https://github.com/mkleehammer/pyodbc/wiki/Drivers-and-Driver-Managers}{The pyodbc "Drivers and Driver Managers" Wiki}
provides further context on drivers and driver managers.
\item \href{https://learn.microsoft.com/en-us/sql/odbc/reference}{Microsoft's "Introduction to ODBC"}
is a thorough resource on the ODBC interface.
}
}

