% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odeintr.R
\name{compile_sys_openmp}
\alias{compile_sys_openmp}
\title{Compile ODE system with openmp multi-threading}
\usage{
compile_sys_openmp(name, sys, pars = NULL, const = FALSE,
  method = "rk5_i", sys_dim = -1L, atol = 1e-06, rtol = 1e-06,
  globals = "", headers = "", footers = "", compile = TRUE,
  env = new.env(), ...)
}
\arguments{
\item{name}{the name of the generated integration function}

\item{sys}{a string containing C++ expressions}

\item{pars}{a named vector of numbers or a vector of names or number of parameters}

\item{const}{declare parameters const if true}

\item{method}{a method string (see \code{\link{compile_sys}})}

\item{sys_dim}{length of the state vector}

\item{atol}{absolute tolerance if using adaptive step size}

\item{rtol}{relative tolerance if using adaptive step size}

\item{globals}{a string with global C++ declarations}

\item{headers}{code to appear before the \code{odeintr} namespace}

\item{footers}{code to appear after the \code{odeintr} namespace}

\item{compile}{if false, just return the code}

\item{env}{install functions into this environment}

\item{...}{passed to \code{\link{sourceCpp}}}
}
\description{
Generates an integrator using Rcpp and openmp
}
\details{
This functions behaves identically to \code{\link{compile_sys}}
execpt that it does not allow one to override the default observer. In
order to take advantage of openmp multi-threading, you must insert
openmp pragmas into your system definition. See the examples.

A special function \code{laplace4} is defined and can be called from
your system definition. It will compute a discrete 4-point Laplacian
for use in solving PDE via the method of lines. The function takes
\code{x} as its first argument, \code{dxdt} as its second argument
and the diffusion coefficient \code{D} as its third parameter. This
function uses the default openmp scheduling.
}
\examples{
\dontrun{
M = 200
bistable = '
 laplace4(x, dxdt, D);  // parallel 4-point discrete laplacian
 #pragma omp parallel for
 for (int i = 0; i < N; ++i)
   dxdt[i] += a * x[i] * (1 - x[i]) * (x[i] - b);
' # bistable
compile_sys_openmp("bistable", bistable, sys_dim = M * M,
                   pars = c(D = 0.1, a = 1.0, b = 1/2),
                   const = TRUE)
at = 10 ^ (0:3)
inic = rbinom(M * M, 1, 1/2)
system.time({x = bistable_at(inic, at)})
par(mfrow = rep(2, 2), mar = rep(1, 4), oma = rep(1, 4))
for (i in 1:4){
  image(matrix(unlist(x[i, -1]), M, M),
        asp = 1, col = c("black", "lightgray"),
        axes = FALSE)
  title(main=paste("Time =", x[i, 1]))}
}

}
\seealso{
\code{\link{set_optimization}}, \code{\link{compile_sys}}
}
\author{
Timothy H. Keitt
}
