% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.2m.R
\name{power.2m}
\alias{power.2m}
\title{Budget and/or sample size, power, MDES calculation for two-level multisite randomized trials}
\usage{
power.2m(cost.model = TRUE, expr = NULL, constraint = NULL,
  sig.level = 0.05, two.tailed = TRUE, d = NULL, power = NULL,
  m = NULL, n = NULL, J = NULL, p = NULL, icc = NULL,
  r12 = NULL, r22m = NULL, q1 = NULL, q2 = NULL, c1 = NULL,
  c2 = NULL, c1t = NULL, omega = NULL, dlim = NULL,
  powerlim = NULL, Jlim = NULL, mlim = NULL, rounded = TRUE)
}
\arguments{
\item{cost.model}{logical; power analyses accommodating costs and budget
(e.g., required budget for desired power, power/MDES under fixed budget)
if TRUE, otherwise conventional power analyses
(e.g., required sample size, power, or MDES calculation); default value is TRUE.}

\item{expr}{returned objects from function \code{\link{od.2m}}; default is NULL;
if \code{expr} is specified, parameter values of \code{icc},
\code{r12}, \code{r22m},
\code{c1}, \code{c2},
\code{c1t}, \code{p}, and \code{n}
used or solved in function \code{\link{od.2m}} will
be passed to current function;
only the values of \code{p} and \code{n} that specified or solved in
function \code{\link{od.2m}} can be overwritten
if \code{constraint} is specified.}

\item{constraint}{specify the constrained values of \code{p} and/or \code{n}
in list format to overwrite those from \code{expr}; default value is NULL.}

\item{sig.level}{significance level or type I error rate, default value is 0.05.}

\item{two.tailed}{logical; two-tailed tests if TRUE,
otherwise one-tailed tests; default value is TRUE.}

\item{d}{effect size.}

\item{power}{statistical power.}

\item{m}{total budget.}

\item{n}{the level-1 sample size per level-2 unit.}

\item{J}{the level-2 sample size per level-3 unit.}

\item{p}{the proportion of level-1 units to be assigned to treatment.}

\item{icc}{the unconditional intraclass correlation coefficient (ICC) in population or in
each treatment condition.}

\item{r12}{the proportion of level-1 variance explained by covariates.}

\item{r22m}{the proportion of variance of site-specific treatment effect explained by covariates.}

\item{q1}{the number of covariates at level 1.}

\item{q2}{the number of covariates at level 2.}

\item{c1}{the cost of sampling one level-1 unit in control condition.}

\item{c2}{the cost of sampling one level-2 unit.}

\item{c1t}{the cost of sampling one level-1 unit in treatment condition.}

\item{omega}{the standardized variance of site-specific treatment effect}

\item{dlim}{the range for searching the root of effect size (\code{d}) numerically,
default value is c(0, 5).}

\item{powerlim}{the range for searching the root of power (\code{power}) numerically,
default value is c(1e-10, 1 - 1e-10).}

\item{Jlim}{the range for searching the root of level-2 sample size (\code{J}) numerically,
default is c(4, 10e10)}

\item{mlim}{the range for searching the root of budget (\code{m}) numerically,
default is the costs sampling \code{Jlim} level-2 units
or c(4 * Jcost, 1e+10 * Jcost) with Jcost =
(1 - p) * c1 * n + p * c1t * n + c2.}

\item{rounded}{logical; round the values of \code{p}, \code{n}/\code{J}/\code{K}
that are from functions \code{\link{od.4}}
to two decimal places and integer, respectively if TRUE,
otherwise no rounding; default value is TRUE.}
}
\value{
Required budget (and/or required level-2 sample size), statistical power, or MDES
    depending on the specification of parameters.
    The function also returns the function name, design type,
    and parameters used in the calculation.
}
\description{
This function can calculate required budget for desired power,
    power or minimum detectable effect size (MDES) under fixed budget
    for two-level multisite randomized trials (MRTs).
    It also can perform conventional power analyses
    (e.g., required sample size, power, and MDES calculation).
}
\examples{
# unconstrained optimal design #---------
  myod1 <- od.2m(icc = 0.2, omega = 0.02, r12 = 0.5, r22m = 0.5,
              c1 = 1, c2 = 10, c1t = 10,
              varlim = c(0, 0.005))
  myod1$out # n = 20, p = 0.37

# ------- power analyses by default considering costs and budget -------
# required budget and sample size
  mym.1 <- power.2m(expr = myod1, d = 0.2, q1 = 1, q2 = 1, power = 0.8)
  mym.1$out  # m = 612, J = 6.3
  # mym.1$par  # parameters and their values used for the function
# or equivalently, specify every argument in the function
  mym.1 <- power.2m(d = 0.2, power = 0.8, q1 = 1, q2 = 1,
                 icc = 0.2, omega = 0.02, r12 = 0.5, r22m = 0.5,
                 c1 = 1, c2 = 10, c1t = 10,
                 n = 20, p = 0.37)
# required budget and sample size with constrained p
  mym.2 <- power.2m(expr = myod1, d = 0.2, q1 = 1, q2 = 1, power = 0.8,
                 constraint = list(p = 0.5))
  mym.2$out  # m = 726, J = 6.1
# required budget and sample size with constrained p and n
  mym.3 <- power.2m(expr = myod1, d = 0.2, q1 = 1, q2 = 1, power = 0.8,
                 constraint = list(p = 0.5, n = 5))
  mym.3$out  # m = 702, J = 18.7

# Power calculation
  mypower <- power.2m(expr = myod1, q1 = 1, q2 = 1, d = 0.2, m = 612)
  mypower$out  # power = 0.80
# Power calculation under constrained p (p = 0.5)
  mypower.1 <- power.2m(expr = myod1, q1 = 1, q2 = 1, d = 0.2, m = 612,
                 constraint = list(p = 0.5))
  mypower.1$out  # power = 0.73

# MDES calculation
  mymdes <- power.2m(expr = myod1, q1 = 1, q2 = 1, power = 0.80, m = 612)
  mymdes$out  # d = 0.20


# ------- conventional power analyses with cost.model = FALSE-------
# Required sample size
  myJ <- power.2m(cost.model = FALSE, expr = myod1, d = 0.2, q1 = 1, q2 = 1, power = 0.8)
  myJ$out  # J = 6.3
  # myL$par  # parameters and their values used for the function
# or equivalently, specify every argument in the function
  myJ <- power.2m(cost.model = FALSE, d = 0.2, power = 0.8, q1 = 1, q2 = 1,
                 icc = 0.2, omega = 0.02, r12 = 0.5, r22m = 0.5,
                 c1 = 1, c2 = 10, c1t = 10,
                 n = 20, p = 0.37)

# Power calculation
  mypower1 <- power.2m(cost.model = FALSE, expr = myod1, J = 6.3, d = 0.2, q1 = 1, q2 = 1)
  mypower1$out  # power = 0.80

# MDES calculation
  mymdes1 <- power.2m(cost.model = FALSE, expr = myod1, J = 6.3, power = 0.8, q1 = 1, q2 = 1)
  mymdes1$out  # d = 0.20

}
\references{
Shen, Z. (in progress). Using optimal sample allocation to
  improve statistical precision and design efficiency for multilevel randomized trials
  (Unpublished doctoral dissertation). University of Cincinnati, Cincinnati, OH.
}
