% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getdata.R
\name{getdata}
\alias{getdata}
\title{Download trade data from OEC's API.}
\usage{
getdata(ORIGIN, DESTINATION, CLASSIFICATION, YEAR)
}
\arguments{
\item{ORIGIN}{is the country code of origin (e.g. "chl" for Chile)}

\item{DESTINATION}{is the country code of origin (e.g. "chn" for China)}

\item{CLASSIFICATION}{refers to the trade classification that can be "6" (HS92 6 characters) or "8" (HS92 8 characters) for the year 1995 and going or "4" (SITC rev.2 4 characters) for the year 1962 and ongoing}

\item{YEAR}{is the year and the OEC's API ranges from 1962 to 2014}
}
\value{
Creates the data files in \code{json} and \code{csv} formats that are needed to create the visualizations.
}
\description{
Download trade data from OEC's API.
}
\examples{
# Run countries_list() to display the full list of countries
# Chile is "chl" and China is "chn"

# Download Chile (chl) and China (chn) trade data (imports, export and trade balance)
getdata("chl", "chn", 6, 2010)

# Download trade data from OEC's API (HS92 6 characters product lists)
getdata("chl", "chn", 6, 2010)

# Download trade data from OEC's API (SITC rev.2 4 characters product lists)
getdata("chl", "chn", 4, 2010)
}
\keyword{functions}

