% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getdata.R
\name{getdata}
\alias{getdata}
\title{Downloads and processes the data from the API}
\usage{
getdata(origin, destination, classification, year)
}
\arguments{
\item{origin}{is the country code of origin (e.g. "chl" for Chile)}

\item{destination}{is the country code of origin (e.g. "chn" for China)}

\item{classification}{refers to the trade classification that can be "6" (HS92 6 characters) or "8" (HS92 8 characters) for the year 1995 and going or "4" (SITC rev.2 4 characters) for the year 1962 and ongoing}

\item{year}{is the year and the OEC's API ranges from 1962 to 2014}
}
\description{
Downloads and processes the data from the API
}
\examples{
# Run countries_list() to display the full list of countries
# Chile is "chl" and China is "chn"

# Download Chile (chl) and China (chn) trade data (imports, export and trade balance)
getdata("chl", "chn", 6, 2010)

# Download trade data from OEC's API (HS92 6 characters product lists)
getdata("chl", "chn", 6, 2010)

# Download trade data from OEC's API (SITC rev.2 4 characters product lists)
getdata("chl", "chn", 4, 2010)
}
\keyword{functions}

