% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storage_helpers.R
\name{Storage}
\alias{Storage}
\title{Storage R6 Object}
\value{
The output depends on the method:
\itemize{
\item \code{$new()} returns a \code{Storage} object.
\item \code{$add()}, \code{$remove()}, and \code{$print()} invisibly return the
\code{Storage} object (to allow for method chaining)
\item \code{$get()} returns the requested element(s)
\item \code{$number()} returns an \code{integer}
\item \code{$indices()} return an \code{integer} \code{vector}
}
}
\description{
Provides a simple indexing interface for list elements based on R6.
Basically, it allows to store items in a list and to regain them based on
identifiers defined by the user.
}
\section{Setting identifiers}{

An identifier is a \code{character}, typically a binary property. Identifiers
can be negated by placing an exclamation mark (\code{"!"}) in front of them.
Identifiers that have been assigned to other elements previously do not need
to be specified again for new elements; instead, a default value can be used.
This default value can be defined either globally for all cases (via the
\code{$missing_identifier} field) or separately for each specific case (via
the method argument).
}

\section{User confirmation}{

If desired, the user can be asked for confirmation when adding, extracting,
or removing elements using identifiers. This behavior can be set globally
through the \code{$confirm} field or customized separately for each specific
case via the method argument.
}

\examples{
### 1. Create a `Storage` object:
my_storage <- Storage$new()

# 2. Add elements along with identifiers:
my_storage$
  add(42, c("number", "rational"))$
  add(pi, c("number", "!rational"))$
  add("fear of black cats", c("text", "!rational"))$
  add("wearing a seat belt", c("text", "rational"))$
  add(mean, "function")

# 3. What elements are stored?
print(my_storage)

# 4. Extract elements based on identifiers:
my_storage$get("rational")
my_storage$get("!rational")
my_storage$get(c("text", "!rational"))
my_storage$get("all") # get all elements
my_storage$get(c("text", "!text"))
my_storage$get(c("text", "!text"), logical = "or")

# 5. Extract elements based on ids:
my_storage$get(ids = 4:5)
my_storage$get(ids = 4:5, id_names = TRUE) # add the ids as names
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{identifier}}{a \code{character} \code{vector}, the identifiers used}

\item{\code{confirm}}{setting the default value for confirmations (either
\code{TRUE} or \code{FALSE})}

\item{\code{missing_identifier}}{setting the default value for not specified
identifiers (either \code{TRUE}, \code{FALSE}, or \code{NA})}

\item{\code{hide_warnings}}{either \code{TRUE} to hide warnings (for example
if unknown identifiers are selected) or \code{FALSE} (default), else}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Storage-new}{\code{Storage$new()}}
\item \href{#method-Storage-add}{\code{Storage$add()}}
\item \href{#method-Storage-get}{\code{Storage$get()}}
\item \href{#method-Storage-remove}{\code{Storage$remove()}}
\item \href{#method-Storage-number}{\code{Storage$number()}}
\item \href{#method-Storage-indices}{\code{Storage$indices()}}
\item \href{#method-Storage-print}{\code{Storage$print()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Storage-new"></a>}}
\if{latex}{\out{\hypertarget{method-Storage-new}{}}}
\subsection{Method \code{new()}}{
initializing a \code{Storage} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Storage$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a new \code{Storage} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Storage-add"></a>}}
\if{latex}{\out{\hypertarget{method-Storage-add}{}}}
\subsection{Method \code{add()}}{
adding an element
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Storage$add(
  x,
  identifier,
  confirm = interactive() & self$confirm,
  missing_identifier = self$missing_identifier
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{any object to be saved}

\item{\code{identifier}}{a \code{character} \code{vector} with one or more identifiers (the identifier
\code{"all"} is reserved to select all elements)}

\item{\code{confirm}}{either \code{TRUE} to be prompted for confirmation, or \code{FALSE} else}

\item{\code{missing_identifier}}{the \code{logical} value for not specified identifiers (either \code{NA},
\code{TRUE}, or \code{FALSE})}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisibly the \code{Storage} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Storage-get"></a>}}
\if{latex}{\out{\hypertarget{method-Storage-get}{}}}
\subsection{Method \code{get()}}{
getting elements
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Storage$get(
  identifier = character(),
  ids = integer(),
  logical = "and",
  confirm = interactive() & self$confirm,
  missing_identifier = self$missing_identifier,
  id_names = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{identifier}}{a \code{character} \code{vector} with one or more identifiers (the identifier
\code{"all"} is reserved to select all elements)}

\item{\code{ids}}{an \code{integer} \code{vector} of one or more ids}

\item{\code{logical}}{in the case that multiple identifiers are selected, how should they be
combined? options are:
\itemize{
\item \code{"and"} (the default): the identifiers are combined with logical and
(all identifiers must be true)
\item \code{"or"}: the identifiers are combined with logical or (at least one
identifier must be true)
}}

\item{\code{confirm}}{either \code{TRUE} to be prompted for confirmation, or \code{FALSE} else}

\item{\code{missing_identifier}}{the \code{logical} value for not specified identifiers (either \code{NA},
\code{TRUE}, or \code{FALSE})}

\item{\code{id_names}}{either \code{TRUE} to name the elements according to their ids or
\code{FALSE} if not}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the selected object(s)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Storage-remove"></a>}}
\if{latex}{\out{\hypertarget{method-Storage-remove}{}}}
\subsection{Method \code{remove()}}{
removing elements
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Storage$remove(
  identifier = character(),
  ids = integer(),
  logical = "and",
  confirm = interactive() & self$confirm,
  missing_identifier = self$missing_identifier,
  shift_ids = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{identifier}}{a \code{character} \code{vector} with one or more identifiers (the identifier
\code{"all"} is reserved to select all elements)}

\item{\code{ids}}{an \code{integer} \code{vector} of one or more ids}

\item{\code{logical}}{in the case that multiple identifiers are selected, how should they be
combined? options are:
\itemize{
\item \code{"and"} (the default): the identifiers are combined with logical and
(all identifiers must be true)
\item \code{"or"}: the identifiers are combined with logical or (at least one
identifier must be true)
}}

\item{\code{confirm}}{either \code{TRUE} to be prompted for confirmation, or \code{FALSE} else}

\item{\code{missing_identifier}}{the \code{logical} value for not specified identifiers (either \code{NA},
\code{TRUE}, or \code{FALSE})}

\item{\code{shift_ids}}{either \code{TRUE} to shift ids when in-between elements are removed,
or \code{TRUE} to keep the ids}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisibly the \code{Storage} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Storage-number"></a>}}
\if{latex}{\out{\hypertarget{method-Storage-number}{}}}
\subsection{Method \code{number()}}{
computing the number of identified elements
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Storage$number(
  identifier = "all",
  missing_identifier = self$missing_identifier,
  logical = "and",
  confirm = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{identifier}}{a \code{character} \code{vector} with one or more identifiers (the identifier
\code{"all"} is reserved to select all elements)}

\item{\code{missing_identifier}}{the \code{logical} value for not specified identifiers (either \code{NA},
\code{TRUE}, or \code{FALSE})}

\item{\code{logical}}{in the case that multiple identifiers are selected, how should they be
combined? options are:
\itemize{
\item \code{"and"} (the default): the identifiers are combined with logical and
(all identifiers must be true)
\item \code{"or"}: the identifiers are combined with logical or (at least one
identifier must be true)
}}

\item{\code{confirm}}{either \code{TRUE} to be prompted for confirmation, or \code{FALSE} else}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an \code{integer}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Storage-indices"></a>}}
\if{latex}{\out{\hypertarget{method-Storage-indices}{}}}
\subsection{Method \code{indices()}}{
returning indices based on defined identifiers
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Storage$indices(
  identifier = "all",
  logical = "and",
  confirm = interactive() & self$confirm
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{identifier}}{a \code{character} \code{vector} with one or more identifiers (the identifier
\code{"all"} is reserved to select all elements)}

\item{\code{logical}}{in the case that multiple identifiers are selected, how should they be
combined? options are:
\itemize{
\item \code{"and"} (the default): the identifiers are combined with logical and
(all identifiers must be true)
\item \code{"or"}: the identifiers are combined with logical or (at least one
identifier must be true)
}}

\item{\code{confirm}}{either \code{TRUE} to be prompted for confirmation, or \code{FALSE} else}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an \code{integer} \code{vector}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Storage-print"></a>}}
\if{latex}{\out{\hypertarget{method-Storage-print}{}}}
\subsection{Method \code{print()}}{
printing details of the saved elements
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Storage$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{currently not used}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisibly the \code{Storage} object
}
}
}
