% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_add.R
\name{body_remove}
\alias{body_remove}
\title{remove an element}
\usage{
body_remove(x)
}
\arguments{
\item{x}{a docx object}
}
\description{
remove element pointed by cursor from a Word document
}
\examples{
library(officer)
library(magrittr)

str1 <- "Lorem ipsum dolor sit amet, consectetur adipiscing elit. " \%>\%
  rep(20) \%>\% paste(collapse = "")
str2 <- "Drop that text"
str3 <- "Aenean venenatis varius elit et fermentum vivamus vehicula. " \%>\%
  rep(20) \%>\% paste(collapse = "")

my_doc <- read_docx()  \%>\%
  body_add_par(value = str1, style = "Normal") \%>\%
  body_add_par(value = str2, style = "centered") \%>\%
  body_add_par(value = str3, style = "Normal")
print(my_doc, target = "init_doc.docx")

my_doc <- read_docx(path = "init_doc.docx")  \%>\%
  cursor_reach(keyword = "that text") \%>\%
  body_remove()
print(my_doc, target = "result_doc.docx")
}
