% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_add.R
\name{body_end_section}
\alias{body_end_section}
\title{add section}
\usage{
body_end_section(x, landscape = FALSE, colwidths = c(1), space = 0.05,
  sep = FALSE)
}
\arguments{
\item{x}{a docx object}

\item{landscape}{landscape orientation}

\item{colwidths}{columns widths in percent, if 3 values, 3 columns will be produced.
Sum of this argument should be 1.}

\item{space}{space in percent between columns.}

\item{sep}{if TRUE a line is sperating columns.}
}
\description{
add a section in a Word document. A section is attached to the latest paragraph
of the section.
}
\details{
A section start at the end of the previous section (or the beginning of
the document if no preceding section exists), it stops where the section is declared.
The function is reflecting that (complicated) Word concept, by adding an ending section
attached to the paragraph where cursor is.
}
\examples{
library(officer)
library(magrittr)

str1 <- "Lorem ipsum dolor sit amet, consectetur adipiscing elit. " \%>\%
  rep(20) \%>\% paste(collapse = "")
str2 <- "Sed hendrerit, est eget convallis vestibulum, mauris ligula. " \%>\%
  rep(20) \%>\% paste(collapse = "")
str3 <- "Aenean venenatis varius elit et fermentum vivamus vehicula. " \%>\%
  rep(20) \%>\% paste(collapse = "")

my_doc <- read_docx()  \%>\%
  body_add_par("String 1", style = "heading 1") \%>\%
  body_add_par(value = str1, style = "Normal") \%>\%
  body_add_par("String 2", style = "heading 1") \%>\%
  body_add_par(value = str2, style = "Normal") \%>\%
  body_end_section(landscape = TRUE, colwidths = c(.6, .4), space = .05, sep = FALSE) \%>\%
  body_add_par("String 3", style = "heading 1") \%>\%
  body_add_par(value = str3, style = "Normal")

if( has_zip() )
  print(my_doc, target = "body_end_section.docx")
}
