% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_add.R
\name{body_add_docx}
\alias{body_add_docx}
\title{insert an external docx}
\usage{
body_add_docx(x, src, pos = "after")
}
\arguments{
\item{x}{an rdocx object}

\item{src}{docx filename}

\item{pos}{where to add the new element relative to the cursor,
one of "after", "before", "on".}
}
\description{
add content of a docx into an rdocx object.
}
\examples{

img.file <- file.path( R.home("doc"), "html", "logo.jpg" )
if( file.exists(img.file) ){
  # create a example file to be inserted later in the final doc----
  doc <- read_docx()
  doc <- body_add_img(x = doc, src = img.file, height = 1.06, width = 1.39 )
  print(doc, target = "external_file.docx")

  # insert external_file.docx in the final doc----
  final_doc <- read_docx()
  doc <- body_add_docx(x = doc, src = "external_file.docx" )
  print(doc, target = "final.docx")
}

}
