% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ph_location.R
\name{ph_location_label}
\alias{ph_location_label}
\title{location of a named placeholder}
\usage{
ph_location_label(ph_label, ...)
}
\arguments{
\item{ph_label}{placeholder label. It can be read in PowerPoint or
with function \code{layout_properties()} in column \code{ph_label}.}

\item{...}{unused arguments}
}
\description{
The function will use the label of a placeholder
to find the corresponding location.
}
\details{
The location of the bounding box associated to a placeholder
within a presentation slide is specified with the left top coordinate,
the width and the height. These are defined in inches:

\describe{
\item{left}{left coordinate of the bounding box}
\item{top}{top coordinate of the bounding box}
\item{width}{width of the bounding box}
\item{height}{height of the bounding box}
}

In addition to these attributes, there is attribute \code{ph_label}
associated with the shape (shapes, text boxes, images and other objects
will be identified with that label in the Selection Pane of PowerPoint).
This label can then be reused by other functions such as \code{ph_add_fpar},
or \code{ph_add_text}.
}
\examples{
library(magrittr)
read_pptx() \%>\%
  add_slide(layout = "Title and Content", master = "Office Theme") \%>\%
  ph_with("Hello world",
    location = ph_location_label(ph_label = "Content Placeholder 2") ) \%>\%
  print(target = tempfile(fileext = ".pptx") )
}
\seealso{
Other functions for placeholder location: \code{\link{ph_location_fullsize}},
  \code{\link{ph_location_left}},
  \code{\link{ph_location_right}},
  \code{\link{ph_location_type}}, \code{\link{ph_location}}
}
\concept{functions for placeholder location}
