% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppt_ph_manipulate.R
\name{ph_add_text}
\alias{ph_add_text}
\title{append text}
\usage{
ph_add_text(x, str, type = "body", id = 1, id_chr = NULL,
  ph_label = NULL, style = fp_text(font.size = 0), pos = "after",
  href = NULL, slide_index = NULL)
}
\arguments{
\item{x}{an rpptx object}

\item{str}{text to add}

\item{type}{placeholder type}

\item{id}{placeholder index (integer) for a duplicated type. This is to be used when a placeholder
type is not unique in the layout of the current slide, e.g. two placeholders with type 'body'. To
add onto the first, use \code{id = 1} and \code{id = 2} for the second one.
Values can be read from \code{\link{slide_summary}}.}

\item{id_chr}{deprecated.}

\item{ph_label}{label associated to the placeholder. Use column
\code{ph_label} of result returned by \code{\link{slide_summary}}.}

\item{style}{text style, a \code{\link{fp_text}} object}

\item{pos}{where to add the new element relative to the cursor,
"after" or "before".}

\item{href}{hyperlink to reach when clicking the text}

\item{slide_index}{slide index to reach when clicking the text.
It will be ignored if \code{href} is not NULL.}
}
\description{
append text in a placeholder.
The function let you add text to an existing
content in an exiisting shape, existing text will be preserved.
}
\section{Usage}{

If your goal is to add formatted text in a new shape, use \code{\link{ph_with}}
with a \code{\link{block_list}} instead of this function.
}

\examples{
fileout <- tempfile(fileext = ".pptx")
my_pres <- read_pptx()
my_pres <- add_slide(my_pres)
my_pres <- ph_empty(my_pres,
  location = ph_location_type(type = "body"))

small_red <- fp_text(color = "red", font.size = 14)

my_pres <- ph_add_par(my_pres, level = 3)
my_pres <- ph_add_text(my_pres, str = "A small red text.",
  style = small_red)
my_pres <- ph_add_par(my_pres, level = 2)
my_pres <- ph_add_text(my_pres, str = "Level 2")

print(my_pres, target = fileout)

# another example ----
fileout <- tempfile(fileext = ".pptx")

doc <- read_pptx()
doc <- add_slide(doc)
doc <- ph_with(doc, "Un titre 2",
  location = ph_location_type(type = "title"))
doc <- ph_empty(doc,
  location = ph_location(rotation = 90, bg = "red",
      newlabel = "myph"))
doc <- ph_add_par(doc, ph_label = "myph", level = 2)
doc <- ph_add_text(doc, str = "Jump here to slide 2!",
  ph_label = "myph")

print(doc, target = fileout)
}
