% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_mle.R
\name{GetMle}
\alias{GetMle}
\title{Estimate Coefficients}
\usage{
GetMle(y, window_size)
}
\arguments{
\item{y}{The original data to find change points.}

\item{window_size}{The number of observations each window contains.}
}
\value{
\item{x}{The transformed data, which are the estimated coefficients of original data.}
}
\description{
Transform N dependent data into approximated independent data (N/window_size) x (L+1).
Computes the estimated coefficients of each window of original data.
}
\examples{
N <- 1000
N1 <- floor(0.1*N)
N2 <- floor(0.3*N)
a1 <- c(0.8, -0.3); c1 <- 0
a2 <- c(-0.5, 0.1); c2 <- 0
a3 <- c(0.5, -0.5); c3 <- 0
y <- rep(0,N)
L<-2
y[1:L] <- rnorm(L)
for (n in (L+1):N){
  if (n <= N1) {
    y[n] <- y[(n-1):(n-L)] \%*\% a1 + c1 + rnorm(1)
  } else if (n <= (N1+N2)) {
    y[n] <- y[(n-1):(n-L)] \%*\% a2 + c2 + rnorm(1)
  }
  else {
    y[n] <- y[(n-1):(n-L)] \%*\% a3 + c3 + rnorm(1)
  }
}
GetMle(y,window_size=100)
}
\references{
J. Ding, Y. Xiang, L. Shen, and V. Tarokh, \emph{Multiple Change Point Analysis:
Fast Implementation and Strong Consistency}. IEEE Transactions on Signal
Processing, vol. 65, no. 17, pp. 4495-4510, 2017.
}
