% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_range.R
\name{PriorRangeOrderKmeans}
\alias{PriorRangeOrderKmeans}
\title{Detect Number and Location of Change Points of Independent Data with Prior
Ranges}
\usage{
PriorRangeOrderKmeans(x, prior_range_x, num_init = NULL)
}
\arguments{
\item{x}{The data to find change points.}

\item{prior_range_x}{The prior ranges that contain change points.}

\item{num_init}{The number of repetition times, in order to avoid local minimal.
Default is squared root of number of observations. Must be integer.}
}
\value{
\item{num_change_point}{optimal number of change points.}
        \item{change_point}{location of change points.}
}
\description{
Detect the number and locations of change points based on minimizing within
segment quadratic loss with restriction of prior ranges that contaion
change points.
}
\details{
The K prior ranges contain K change points, each prior range contaions one
change point.
}
\examples{
a<-matrix(rnorm(40,mean=-1,sd=1),nrow=20,ncol=2)
b<-matrix(rnorm(120,mean=0,sd=1),nrow=60,ncol=2)
c<-matrix(rnorm(40,mean=1,sd=1),nrow=20,ncol=2)
x<-rbind(a,b,c)
l1<-c(15,25)
l2<-c(75,100)
prior_range_x<-list(l1,l2)
PriorRangeOrderKmeans(x,prior_range_x=list(l1,l2))
}
\references{
J. Ding, Y. Xiang, L. Shen, and V. Tarokh, \emph{Multiple Change Point Analysis:
Fast Implementation and Strong Consistency}. IEEE Transactions on Signal
Processing, vol. 65, no. 17, pp. 4495-4510, 2017.
}
