\name{is.cleancall}
\alias{is.cleancall}
\title{check if there are dots in a call}
\description{This function is designed to be called within functions that call the  collection function, and should not be called by the user. However, it is important to understand it's purpose in order to use the collection function, or any other function that calls the collection function. By default (if resolve is true) the collection function tries to resolve argument names, so that we do not have to explicitly name each argument. For any argument, there are three main cases (1) the argument is in the form name=value, (2) just a name, or (3) just a value. For the first and second cases, the name is obviously the name we provide. For the third case the collection function does not assign a name. If we call collection directly, the collection function retrieves the call to collection via match.call and examines the arguments, then determines the appropriate names. However if we call collection indirectly (using dots as an argument), this process does not work. R will automatically name any unnamed arguments represented by the dots. This means that collection will assign a name for an argument that is unnamed in the original call. This problem can be partially solved, either by setting resolve to false, or by setting the collection call argument to the call with the original arguments. Unfortunately a function calling collection in this manor, can only check if the call to that function, is clean (here meaning no dots) and not what the original call is. The compenv and freemethod functions (that ultimately require arguments to be named or nameable) makes use of this principle. If the call to these functions is clean, then they call collection, setting the collection call argument appropriately. However, if the call is not clean, then they set resolve to false, meaning that actual argument names are used. However, as these functions require named or nameable arguments, if the call is not clean, then the original call must explicitly name every argument. Example, we can call compenv (x, y), if we have objects x and y defined, however we can not create another function that calls compenv (...) inside it, unless the original call explicitly names each argument, x=x, y=y, etc.}
\usage{
is.cleancall ()
}
\arguments{}

