% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rhenery}
\alias{rhenery}
\title{Random generation under the Henery (or Harville) softmax model.}
\usage{
rhenery(mu, gamma = NULL)
}
\arguments{
\item{mu}{a vector of the probabilities of taking first place.}

\item{gamma}{a vector of the gamma coefficients. Should have length
one less than \code{mu}, but if longer the unused elements are ignored.
If shorter, we reserve the right to either throw an error or extend out
the last gamma element. If not given, the coefficients are assumed
to be all one, which is the Harville model.}
}
\value{
A vector, of the same length as the probabilities, giving
the entry of each horse. Note that the expected value of this
returned thing makes sense, it is \emph{not} the finished rank ordering
of a race.
}
\description{
Given base probabilities, and Henery gamma coefficients,
performs random generation, using R's built in rand seed,
of the final outcome of a race for each participant.
}
\details{
Given vectors \eqn{\mu} and \eqn{\gamma}, first computes
\deqn{\pi_{1,i} = \frac{\mu_i^{\gamma_1}}{\sum_j \mu_j^{\gamma_1}},}
then assigns a \eqn{1} to participant \eqn{i} with probability
\eqn{\pi_{1,i}}. The \sQuote{winning} participant is then removed
from consideration, and the process is repeated using the remaining
\eqn{\mu} and \eqn{\gamma} vectors.

Typically one has that \eqn{\mu_i = \exp{\eta_i}}, for some
\sQuote{odds}, \eqn{\eta_i}.

When the \eqn{\gamma} are all one, you recover the Harville softmax
model.
}
\seealso{
\code{\link{rsm}}
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\keyword{probability}
