% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ohsome_parse.R
\name{ohsome_parse}
\alias{ohsome_parse}
\alias{ohsome_sf}
\alias{ohsome_df}
\title{Parse content from an ohsome API response}
\usage{
ohsome_parse(
  response,
  returnclass = c("default", "sf", "data.frame", "list", "character"),
  omit_empty = TRUE
)

ohsome_sf(response, omit_empty = TRUE)

ohsome_df(response, omit_empty = TRUE)
}
\arguments{
\item{response}{An \code{ohsome_response} object}

\item{returnclass}{character; one of the following:
\itemize{
\item \code{"default"} returns \code{sf} if the \code{ohsome_response} contains GeoJSON, or
else a \code{data.frame}.
\item \code{"sf"} returns \code{sf} if the \code{ohsome_response} contains GeoJSON, else
issues a warning and returns a \code{data.frame}.
\item \code{"data.frame"} returns a \code{data.frame}.
\item \code{"list"} returns a \code{list}.
\item \code{"character"} returns the ohsome API response body as text (JSON or
semicolon-separated values)
}}

\item{omit_empty}{logical; omit features with empty geometries (only if
\code{returnclass = "sf"})}
}
\value{
An \code{sf} object, a \code{data.frame}, a \code{list} or a \code{character}
}
\description{
Extracts and parses the content from an ohsome API response
}
\details{
\code{ohsome_parse()} parses an \code{ohsome_response} object into an object of the
specified class. By default, this is an \code{sf} object if the ohsome API
response contains GeoJSON data or a \code{data.frame} if it does not.
\code{ohsome_sf()} and \code{ohsome_df()} wrapper functions for specific return
classes.
}
\examples{
\dontrun{
# Create and send a query to ohsome API
r <- ohsome_query("elements/centroid", filter = "amenity=*") |>
    set_boundary(osmdata::getbb("Heidelberg")) |>
    set_time("2021") |>
    set_properties("metadata") |>
    ohsome_post(parse = FALSE)

# Parse response to object of default class (here: sf)
ohsome_parse(r)

# Parse response to data.frame
ohsome_df(r)

# Parse response to sf
ohsome_sf(r)
}

}
\concept{Extract and parse the content from an ohsome API response}
