% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_detection.R
\name{filter_detection}
\alias{filter_detection}
\title{Remove ambiguous detections}
\usage{
filter_detection(detection, by = "overlap", filter = "max", cores = 1, pb = TRUE)
}
\arguments{
\item{detection}{Data frame or selection table (using the warbleR package's format, see \code{\link[warbleR]{selection_table}}) with the output of \code{\link{label_detection}} containing the start and end of the signals. Must contained at least the following columns: "sound.files", "selec", "start", "end", "detection.class" and "reference.row" (these last 2 are generated by \code{\link{label_detection}}). It must also contained the column indicated in the 'by' argument.}

\item{by}{Character vector of length 1 indicating a column in 'detection' that will be used to filter delections. Must refer to a numeric column. Default is 'overlap', which is return by \code{\link{label_detection}}.}

\item{filter}{Character vector of length 1 indicating the criterium used to filter the column refer to by the 'by' argument. Current options are 'max' (maximum) and 'min' (minimum). Default is 'max'.}

\item{cores}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}.}
}
\value{
A data frame or selection table (if 'detection' was also a selection table, warbleR package's format, see \code{\link[warbleR]{selection_table}}) as in 'X' but removing ambiguous detections (split and merged positives).
}
\description{
\code{filter_detection} removes ambiguous detections (split and merged detections)
}
\details{
This function removes ambiguous detections (split or merged detections, see \code{\link{diagnose_detection}}) keeping only the one that maximizes a criterium given by 'filter'. By default it keeps the detection with the highest overlap to the reference signal. It works on the output of \code{\link{label_detection}}.
}
\examples{
{
# load example data
data("lbh1", "lbh_reference")

# save sound files
writeWave(lbh1, file.path(tempdir(), "lbh1.wav"))

# template for the first sound file in 'lbh_reference'
templ1 <- lbh_reference[1, ]

# generate template correlations
tc <- template_correlator(templates = templ1, path = tempdir(),
files = "lbh1.wav")

# template detection
td <- template_detector(template.correlations = tc, threshold = 0.12)

# this detection generates 2 split positives
diagnose_detection(reference = lbh_reference[lbh_reference == "lbh1.wav", ],
detection = td)

# label detection
ltd <- label_detection(reference = lbh_reference[lbh_reference == "lbh1.wav", ],
detection = td)

# now they can be filter to keep the detection with the highest score for each split
ftd <- filter_detection(ltd)

# splits must be 0
diagnose_detection(reference = lbh_reference[lbh_reference == "lbh1.wav", ],
detection = ftd)
}

}
\references{
{
#' Araya-Salas, M. (2021), ohun: diagnosing and optimizing automated sound event detection. R package version 0.1.0.
}
}
\seealso{
\code{\link{label_detection}}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr}).
}
