library(shiny)
library(ggplot2)
library(descriptr)
library(olsrr)
library(dplyr)
library(grid)
library(gridExtra)
library(purrr)
library(tidyr)
library(tibble)
library(readxl)
library(readr)
library(jsonlite)
library(magrittr)
library(tools)
library(caret)
library(lubridate)
library(scales)
library(stringr)

shinyServer(function(input, output, session) {
    
    source("logic/logic_dataoptions.R", local = T)
    source("logic/logic_upload.R", local = T)
    source("logic/logic_transform2.R", local = T)
    source("logic/logic_select.R", local = T)
    source("logic/logic_filter.R", local = T)
    source("logic/logic_screen.R", local = T)
    source("logic/logic_sample.R", local = T)
    source("logic/logic_partition.R", local = T)
    source("logic/logic_view.R", local = T)
    source("logic/logic_regress.R", local = T)
    # source("logic/logic_mselection2.R", local = T)
    source("logic/logic_resdiagtrial.R", local = T)
    source("logic/logic_hetero.R", local = T)
    source("logic/logic_collin.R", local = T)
    source("logic/logic_inflobs2.R", local = T)
    source("logic/logic_mfit2.R", local = T)
    source("logic/logic_regdiag.R", local = T)
    source("logic/logic_home.R", local = T)
})


