% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-plots-data.R
\name{ols_prep_dfbeta_data}
\alias{ols_prep_dfbeta_data}
\title{DFBETAs plot data}
\usage{
ols_prep_dfbeta_data(d, threshold)
}
\arguments{
\item{d}{A \code{tibble} or \code{data.frame} with dfbetas.}

\item{threshold}{The threshold for outliers.}
}
\description{
Prepares the data for dfbetas plot.
}
\examples{
model <- lm(mpg ~ disp + hp + wt + qsec, data = mtcars)
dfb <- dfbetas(model)
n <- nrow(dfb)
threshold <- 2 / sqrt(n)
dbetas  <- dfb[, 1]
df_data <- data.frame(obs = seq_len(n), dbetas = dbetas)
ols_prep_dfbeta_data(df_data, threshold)

}
