% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-f-test.R
\name{ols_test_f}
\alias{ols_test_f}
\alias{ols_f_test}
\title{F test}
\usage{
ols_test_f(model, fitted_values = TRUE, rhs = FALSE, vars = NULL,
  ...)
}
\arguments{
\item{model}{An object of class \code{lm}.}

\item{fitted_values}{Logical; if TRUE, use fitted values of regression model.}

\item{rhs}{Logical; if TRUE, specifies that tests for heteroskedasticity be
performed for the right-hand-side (explanatory) variables of the fitted
regression model.}

\item{vars}{Variables to be used for for heteroskedasticity test.}

\item{...}{Other arguments.}
}
\value{
\code{ols_test_f} returns an object of class \code{"ols_test_f"}.
An object of class \code{"ols_test_f"} is a list containing the
following components:

\item{f}{f statistic}
\item{p}{p-value of \code{f}}
\item{fv}{fitted values of the regression model}
\item{rhs}{names of explanatory variables of fitted regression model}
\item{numdf}{numerator degrees of freedom}
\item{dendf}{denominator degrees of freedom}
\item{vars}{variables to be used for heteroskedasticity test}
\item{resp}{response variable}
\item{preds}{predictors}
}
\description{
Test for heteroskedasticity under the assumption that the errors are
independent and identically distributed (i.i.d.).
}
\section{Deprecated Function}{

\code{ols_f_test()} has been deprecated. Instead use \code{ols_test_f()}.
}

\examples{
# model
model <- lm(mpg ~ disp + hp + wt + qsec, data = mtcars)

# using fitted values
ols_test_f(model)

# using all predictors of the model
ols_test_f(model, rhs = TRUE)

# using fitted values
ols_test_f(model, vars = c('disp', 'hp'))

}
\references{
Wooldridge, J. M. 2013. Introductory Econometrics: A Modern Approach. 5th ed. Mason, OH: South-Western.
}
\seealso{
Other heteroskedasticity tests: \code{\link{ols_test_bartlett}},
  \code{\link{ols_test_breusch_pagan}},
  \code{\link{ols_test_score}}
}
\concept{heteroskedasticity tests}
