% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-standardized-residual-chart.R
\name{ols_plot_resid_stand}
\alias{ols_plot_resid_stand}
\title{Standardized residual chart}
\usage{
ols_plot_resid_stand(model, threshold = NULL, print_plot = TRUE)
}
\arguments{
\item{model}{An object of class \code{lm}.}

\item{threshold}{Threshold for detecting outliers. Default is 2.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a plot object.}
}
\value{
\code{ols_plot_resid_stand} returns  a list containing the
following components:

\item{outliers}{a \code{data.frame} with observation number and \code{standardized resiudals} that
exceed \code{threshold}} for classifying an observation as an outlier
\item{threshold}{\code{threshold} for classifying an observation as an outlier}
}
\description{
Chart for identifying outliers.
}
\details{
Standardized residual (internally studentized) is the residual divided by
estimated standard deviation.
}
\examples{
model <- lm(mpg ~ disp + hp + wt, data = mtcars)
ols_plot_resid_stand(model)
ols_plot_resid_stand(model, threshold = 3)

}
\seealso{
\code{\link[=ols_plot_resid_stud]{ols_plot_resid_stud()}}
}
