% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omicwas.R
\name{ctassoc}
\alias{ctassoc}
\title{Cell-Type-Specific Association Testing}
\usage{
ctassoc(
  X,
  W,
  Y,
  C = NULL,
  test = "ridge",
  num.cores = 1,
  chunk.size = 1000,
  seed = 123
)
}
\arguments{
\item{X}{Matrix (or vector) of traits; samples x traits.}

\item{W}{Matrix of proportion of cell types; samples x cell types.}

\item{Y}{Matrix (or vector) of bulk omics measurements; markers x samples.}

\item{C}{Matrix (or vector) of covariates; samples x covariates.
X, W, Y, C should be numeric.}

\item{test}{Statistical test to apply; either \code{"reducedrankridge"},
\code{"ridge"}, \code{"full"} or \code{"marginal"}.}

\item{num.cores}{Number of CPU cores to use.
Full and marginal tests are run in serial, thus num.cores is ignored.}

\item{chunk.size}{The size of job for a CPU core in one batch.
If you have many cores but limited memory, and there is a memory failure,
decrease num.cores and/or chunk.size.}

\item{seed}{Seed for random number generation.}
}
\value{
A list with one element, which is named "coefficients".
The element gives the estimate, statistic, p.value in tibble format.
}
\description{
Cell-Type-Specific Association Testing
}
\details{
Let the indexes be
\eqn{h} for cell type, \eqn{i} for sample,
\eqn{j} for marker (CpG site or gene),
\eqn{k} for each trait that has cell-type-specific effect,
and \eqn{l} for each trait that has bulk tissue effect.
The input data are \eqn{X_{i k}}, \eqn{C_{i l}}, \eqn{W_{i h}} and \eqn{Y_{j i}},
where \eqn{C_{i l}} can be omitted.
\eqn{X_{i k}} and \eqn{C_{i l}} are the two types of traits,
showing effects that are cell-type-specific or not, respectively.
Thus, calling \eqn{X_{i k}} and \eqn{C_{i l}} as "traits" and "covariates"
gives a rough idea, but is not strictly correct.
\eqn{W_{i h}} represents the cell type proportion and
\eqn{Y_{j i}} represents the marker level,
such as methylation or gene expression.
For each tissue sample, the cell type proportion \eqn{W_{i h}}
is the proportion of each cell type in the bulk tissue,
which is measured or imputed beforehand.
The marker level \eqn{Y_{j i}} in bulk tissue is measured and provided as input.

The cell-type-specific marker level \eqn{Z_{h j i}} is not observed
and is treated as a hidden variable.
The parameters we estimate are
the effect of cell-type-specific traits \eqn{\beta_{h j k}},
the effect of non-specific traits \eqn{\gamma_{j l}},
and the cell-type-specific basal marker level \eqn{\mu_{h j}}.

We assume normal distribution for the cell-type-specific marker level,
\deqn{Z_{h j i} ~ N(\mu_{h j} + \sum_k \beta_{h j k} * X_{i k}, \sigma^2_{h j}).}
Since the bulk tissue marker level is the sum weighted by \eqn{W_{i h}},
\deqn{Y_{j i} ~ N(\sum_h W_{i h} [\mu_{h j} + \sum_k \beta_{h j k} * X_{i k}] +
                  \sum_l \gamma_{j l} C_{i l}, \tau^2_j).}
Although formally, the variance comprises of components of cell type level
and tissue level, we approximate and unify into \eqn{\tau^2_j}.

The \code{full} model is the linear regression
\deqn{Y_{j i} ~ (\sum_h \mu_{h j} * W_{i h}) +
                (\sum_{h k} \beta_{h j k} * W_{i h} * X_{i k}) +
                (\sum_l \gamma_{j l} * C_{i l}) +
                error.}
The \code{ridge} model aims to cope with multicollinearity of
the interacting terms \eqn{W_{i h} * X_{i k}}.
It first adjusts for \eqn{\mu_{h j}} and \eqn{\gamma_{j l}}
by fitting linear regression and taking the residuals.
Afterwards, ridge regression is used to fit \eqn{\beta_{h j k}}.
We use the \link[ridge]{linearRidge} function of the ridge package.
The \code{marginal} model tests the trait association only in one
cell type \eqn{h}, under the linear regression,
\deqn{Y_{j i} ~ (\sum_{h'} \mu_{h' j} * W_{i h'}) +
                (\sum_k \beta_{h j k} * W_{i h} * X_{i k}) +
                (\sum_l \gamma_{j l} * C_{i l}) +
                error.}
}
\examples{
\donttest{
data(GSE42861small)
X = GSE42861small$X
Y = GSE42861small$Y
W = GSE42861small$W
C = GSE42861small$C
Y = ctRUV(X, W, Y, C = C)
result = ctassoc(X, W, Y, C = C)
result$coefficients
}

}
\seealso{
ctRUV
}
