% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/longRun.r
\name{longRun}
\alias{longRun}
\title{Length of the longest run of a particular value in a numeric vector}
\usage{
longRun(x, val, wrap = FALSE, na.rm = FALSE)
}
\arguments{
\item{x}{Numeric vector.}

\item{val}{Numeric. Value of the elements of \code{x} of which to calculate length of longest run.}

\item{wrap}{Logical. If \code{TRUE} then runs can "wrap" from the end of \code{x} to the start of \code{x} if the first and last elements of \code{x} are equal to \code{val}.}

\item{na.rm}{Logical. If \code{TRUE} then remove \code{NA}s first.}
}
\value{
Integer.
}
\description{
This function returns the lengh of the longest run of a particular numeric value in a numeric vector.  A "run" is an uninterrupted  sequence of the same number. Runs can be "wrapped" so that if the sequence starts and ends with the target value then it is considered as a consecutive run.
}
\examples{
x <- c(1, 1, 1, 2, 2, 3, 4, 5, 6, 1, 1, 1, 1, 1)
longRun(x, 2)
longRun(x, 1)
longRun(x, 1, wrap=TRUE)
}
\seealso{
[base::rle()]
}
