% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stretchMinMax.r
\name{stretchMinMax}
\alias{stretchMinMax}
\title{Rescale values}
\usage{
stretchMinMax(
  x,
  lower = 0,
  upper = 1,
  nudgeUp = FALSE,
  nudgeDown = FALSE,
  na.rm = FALSE
)
}
\arguments{
\item{x}{Numeric list.}

\item{lower}{Numeric, low end of range to which to stretch.}

\item{upper}{Numeric, high end of range to which to stretch.}

\item{nudgeUp, nudgeDown}{Logical, if \code{FALSE} (default) then do nothing. If \code{TRUE} then *after* rescaling to [0, 1], a small value will be added to all values of \code{x} equal to 0. This value is equal to \code{0.5 * min(x[x > 0])}.}

\item{na.rm}{Logical, if \code{FALSE} (default) then if any values of \code{x} are \code{NA} then the returned value will be \code{NA}. If \code{TRUE} then \code{NA}'s are ignored in calculation.}
}
\value{
Numeric value.
}
\description{
This function rescales a vector of numeric values to an arbitrary range. Optionally, after the stretch values equal to the lowest value can be "nudged" slightly higher to half the minimum value across the rescaled vector of values > 0.
}
\examples{

x <- 1:10
stretchMinMax(x)
stretchMinMax(x, lower=2, upper=5)
stretchMinMax(x, nudgeUp=TRUE)
stretchMinMax(x, lower=2, upper=5, nudgeUp=TRUE)
stretchMinMax(x, nudgeDown=TRUE)
stretchMinMax(x, lower=2, upper=5, nudgeUp=TRUE, nudgeDown=TRUE)
x <- c(1:5, NA)
stretchMinMax(x)
stretchMinMax(x, na.rm=TRUE)

}
\seealso{
\code{\link[base]{scale}}
}
