% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classCohortTable.R
\name{emptyCohortTable}
\alias{emptyCohortTable}
\title{Create an empty cohort_table object}
\usage{
emptyCohortTable(cdm, name)
}
\arguments{
\item{cdm}{A cdm_reference to create the table.}

\item{name}{Name of the table to create.}
}
\value{
The cdm_reference with an empty cohort table
}
\description{
Create an empty cohort_table object
}
\examples{
library(omopgenerics)
library(dplyr, warn.conflicts = FALSE)

person <- tibble(
  person_id = 1, gender_concept_id = 0, year_of_birth = 1990,
  race_concept_id = 0, ethnicity_concept_id = 0
)
observation_period <- tibble(
  observation_period_id = 1, person_id = 1,
  observation_period_start_date = as.Date("2000-01-01"),
  observation_period_end_date = as.Date("2025-12-31"),
  period_type_concept_id = 0
)
cdm <- cdmFromTables(
  tables = list("person" = person, "observation_period" = observation_period),
  cdmName = "test"
)

cdm <- emptyCohortTable(cdm, "my_empty_cohort")

cdm
cdm$my_empty_cohort
settings(cdm$my_empty_cohort)
attrition(cdm$my_empty_cohort)
cohortCount(cdm$my_empty_cohort)

}
