% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{validateColumn}
\alias{validateColumn}
\title{Validate whether a variable points to a certain exiting column in a table.}
\usage{
validateColumn(
  column,
  x,
  type = c("character", "date", "logical", "numeric", "integer"),
  validation = "error",
  call = parent.frame()
)
}
\arguments{
\item{column}{Name of a column that you want to check that exist in \code{x}
table.}

\item{x}{Table to check if the column exist.}

\item{type}{Type of the column.}

\item{validation}{Whether to throw warning or error.}

\item{call}{Passed to cli functions.}
}
\value{
the validated name
}
\description{
Validate whether a variable points to a certain exiting column in a table.
}
\examples{
x <- dplyr::tibble(a = 1, b = "xxx")

validateColumn("a", x, validation = "warning")
validateColumn("a", x, type = "character", validation = "warning")
validateColumn("a", x, type = "numeric", validation = "warning")
validateColumn("not_existing", x, type = "numeric", validation = "warning")

}
