% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign_hierarchy.R
\name{assign_hierarchy}
\alias{assign_hierarchy}
\title{Assign hierarchy metadata}
\usage{
assign_hierarchy(count_data, keep_unknowns, identifier)
}
\arguments{
\item{count_data}{a metabolomics count data frame with either a KEGG compound, orthology,
or a gene identifier column}

\item{keep_unknowns}{a boolean of either TRUE or FALSE. TRUE keeps unannotated compounds,
FALSE removes them}

\item{identifier}{a string that is either "KEGG" for metabolite, "KO_Number" for orthology,
"Prokaryote" for organism, or "Eukaryote" for organism}
}
\description{
Assigns hierarchy metadata to a metabolomics count matrix using identifier values.
It can assign KEGG compound hierarchy, orthology hierarchy, or organism hierarchy data.
}
\examples{
assign_hierarchy(count_data = c57_nos2KO_mouse_countDF, keep_unknowns = TRUE, identifier = "KEGG")
}
