% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_report.R
\name{save_report}
\alias{save_report}
\title{Save Onbrand Report to a File}
\usage{
save_report(obnd, output_file = NULL, verbose = TRUE)
}
\arguments{
\item{obnd}{onbrand report object}

\item{output_file}{File name to save the report.}

\item{verbose}{Boolean variable when set to TRUE (default) messages will be
displayed on the terminal; Messages will be included in the returned onbrand
object.}
}
\value{
List with the following elements
\itemize{
\item{isgood}: Boolean variable indicating success or failure
\item{msgs}:   Vector of messages
}
}
\description{
Saves report in onbrand object to the specified file.
}
\examples{

obnd = read_template(
      template = file.path(system.file(package="onbrand"), "templates", "report.pptx"),
      mapping  = file.path(system.file(package="onbrand"), "templates", "report.yaml"))

save_report(obnd, tempfile(fileext = ".pptx"))

obnd = read_template(
      template = file.path(system.file(package="onbrand"), "templates", "report.docx"),
      mapping  = file.path(system.file(package="onbrand"), "templates", "report.yaml"))

save_report(obnd, tempfile(fileext = ".docx"))

}
